% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intermittent_pumping.R
\name{intermittent_pumping}
\alias{intermittent_pumping}
\title{Streamflow depletion for an intermittent pumping schedule using superposition.}
\usage{
intermittent_pumping(t, starts, stops, rates, method = "glover", d, S, Tr, ...)
}
\arguments{
\item{t}{times you want output for [T]}

\item{starts}{vector of times to start pumping [T] (must be same length as stops and rates)}

\item{stops}{vector of times pumping stops [T] (must be same length as starts and rates)}

\item{rates}{vector of pumping rates [L3/T] (must be same length as starts and stops)}

\item{method}{analytical solution to use (options= 'glover', 'hunt'). Defaults to 'glover'.}

\item{d}{distance from well to stream [L]}

\item{S}{aquifer storage coefficient (specific yield if unconfined; storativity if confined)}

\item{Tr}{aquifer transmissivity [L2/T]}

\item{...}{any other inputs required for your \code{method} of choice; for example, \link{hunt} needs \code{lmda} (streambed conductance)}
}
\value{
A numeric of \code{Qs}, streamflow depletion rate [L3/T].
}
\description{
Streamflow depletion for an intermittent pumping schedule using superposition.
}
\details{
This function superimposes wells and image wells to calculate a timeseries of streamflow depletion.
Unlike the streamflow depletion models (e.g. \link{glover}, \link{hunt}) this is not fractional depletion (\code{Qf})
because there can be different pumping rates at different times.
}
\examples{
\donttest{Qs <- intermittent_pumping(t = seq(0, 1000, 5),
 starts = seq(0, 900, 10), stops = seq(9, 909, 10), rates = seq(1, 1000, length.out=91),
 method = "hunt", d = 100, S = 0.1, Tr = 100, lmda = 10)}

\donttest{Qs <- intermittent_pumping(t = seq(0, 1000, 5),
 starts = seq(0, 900, 10), stops = seq(9, 909, 10), rates = seq(1, 1000, length.out=91),
 method = "hunt", d = 100, S = 0.1, Tr = 100, lmda = 100000, lmda_max = 10)}
}
\references{
Jenkins, C.T. (1968). Techniques for Computing Rate and Volume of Stream Depletion
by Wells. Ground Water 6(2): 37-46. doi:10.1111/j.1745-6584.1968.tb01641.x
}
