/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.options.FloatOption;
import moa.options.MultiChoiceOption;
import moa.tasks.TaskMonitor;

public class HDDM_A_Test
extends AbstractChangeDetector {
    public FloatOption driftConfidenceOption = new FloatOption("driftConfidence", 'd', "Confidence to the drift", 0.001, 0.0, 1.0);
    public FloatOption warningConfidenceOption = new FloatOption("warningConfidence", 'w', "Confidence to the warning", 0.005, 0.0, 1.0);
    public MultiChoiceOption oneSidedTestOption = new MultiChoiceOption("typeOfTest", 't', "Monitors error increments and decrements (two-sided) or only increments (one-sided)", new String[]{"One-sided", "Two-sided"}, new String[]{"One-sided", "Two-sided"}, 1);
    protected int n_min = 0;
    protected double c_min = 0.0;
    protected int total_n = 0;
    protected double total_c = 0.0;
    protected int n_max = 0;
    protected double c_max = 0.0;
    protected double cEstimacion = 0.0;
    protected int nEstimacion = 0;

    public HDDM_A_Test() {
        this.resetLearning();
    }

    public void input(double value) {
        double cota1;
        double cota;
        ++this.total_n;
        this.total_c += value;
        if (this.n_min == 0) {
            this.n_min = this.total_n;
            this.c_min = this.total_c;
        }
        if (this.n_max == 0) {
            this.n_max = this.total_n;
            this.c_max = this.total_c;
        }
        if (this.c_min / (double)this.n_min + (cota = Math.sqrt(1.0 / (double)(2 * this.n_min) * Math.log(1.0 / this.driftConfidenceOption.getValue()))) >= this.total_c / (double)this.total_n + (cota1 = Math.sqrt(1.0 / (double)(2 * this.total_n) * Math.log(1.0 / this.driftConfidenceOption.getValue())))) {
            this.c_min = this.total_c;
            this.n_min = this.total_n;
        }
        if (this.c_max / (double)this.n_max - (cota = Math.sqrt(1.0 / (double)(2 * this.n_max) * Math.log(1.0 / this.driftConfidenceOption.getValue()))) <= this.total_c / (double)this.total_n - cota1) {
            this.c_max = this.total_c;
            this.n_max = this.total_n;
        }
        if (this.meanIncr(this.c_min, this.n_min, this.total_c, this.total_n, this.driftConfidenceOption.getValue())) {
            this.nEstimacion = this.total_n - this.n_min;
            this.cEstimacion = this.total_c - this.c_min;
            this.total_n = 0;
            this.n_max = 0;
            this.n_min = 0;
            this.total_c = 0.0;
            this.c_max = 0.0;
            this.c_min = 0.0;
            this.isChangeDetected = true;
            this.isWarningZone = false;
        } else if (this.meanIncr(this.c_min, this.n_min, this.total_c, this.total_n, this.warningConfidenceOption.getValue())) {
            this.isChangeDetected = false;
            this.isWarningZone = true;
        } else {
            this.isChangeDetected = false;
            this.isWarningZone = false;
        }
        if (this.oneSidedTestOption.getChosenIndex() == 1 && this.meanDecr(this.c_max, this.n_max, this.total_c, this.total_n)) {
            this.nEstimacion = this.total_n - this.n_max;
            this.cEstimacion = this.total_c - this.c_max;
            this.total_n = 0;
            this.n_max = 0;
            this.n_min = 0;
            this.total_c = 0.0;
            this.c_max = 0.0;
            this.c_min = 0.0;
        }
        this.updateEstimations();
    }

    private boolean meanIncr(double c_min, int n_min, double total_c, int total_n, double confianzaCambio) {
        if (n_min == total_n) {
            return false;
        }
        double m = (double)(total_n - n_min) / (double)n_min * (1.0 / (double)total_n);
        double cota = Math.sqrt(m / 2.0 * Math.log(2.0 / confianzaCambio));
        return total_c / (double)total_n - c_min / (double)n_min >= cota;
    }

    private boolean meanDecr(double c_max, int n_max, double total_c, int total_n) {
        if (n_max == total_n) {
            return false;
        }
        double m = (double)(total_n - n_max) / (double)n_max * (1.0 / (double)total_n);
        double cota = Math.sqrt(m / 2.0 * Math.log(2.0 / this.driftConfidenceOption.getValue()));
        return c_max / (double)n_max - total_c / (double)total_n >= cota;
    }

    public void resetLearning() {
        super.resetLearning();
        this.n_min = 0;
        this.c_min = 0.0;
        this.total_n = 0;
        this.total_c = 0.0;
        this.n_max = 0;
        this.c_max = 0.0;
        this.cEstimacion = 0.0;
        this.nEstimacion = 0;
    }

    protected void updateEstimations() {
        if (this.total_n >= this.nEstimacion) {
            this.nEstimacion = 0;
            this.cEstimacion = 0;
            this.estimation = this.total_c / (double)this.total_n;
            this.delay = this.total_n;
        } else {
            this.estimation = this.cEstimacion / (double)this.nEstimacion;
            this.delay = this.nEstimacion;
        }
    }

    public double getEstimation() {
        return this.estimation;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.resetLearning();
    }
}

