/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy.neighboursearch;

import java.io.Serializable;
import moa.classifiers.lazy.neighboursearch.DistanceFunction;
import moa.classifiers.lazy.neighboursearch.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;

public abstract class NearestNeighbourSearch
implements Serializable {
    protected Instances m_Instances;
    protected int m_kNN;
    protected DistanceFunction m_DistanceFunction = new EuclideanDistance();
    protected boolean m_MeasurePerformance = false;

    public NearestNeighbourSearch() {
    }

    public NearestNeighbourSearch(Instances insts) {
        this();
        this.m_Instances = insts;
    }

    public String globalInfo() {
        return "Abstract class for nearest neighbour search. All algorithms (classes) that do nearest neighbour search should extend this class.";
    }

    public String distanceFunctionTipText() {
        return "The distance function to use for finding neighbours (default: weka.core.EuclideanDistance). ";
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public void setDistanceFunction(DistanceFunction df) throws Exception {
        this.m_DistanceFunction = df;
    }

    public String measurePerformanceTipText() {
        return "Whether to calculate performance statistics for the NN search or not";
    }

    public boolean getMeasurePerformance() {
        return this.m_MeasurePerformance;
    }

    public abstract Instance nearestNeighbour(Instance var1) throws Exception;

    public abstract Instances kNearestNeighbours(Instance var1, int var2) throws Exception;

    public abstract double[] getDistances() throws Exception;

    public abstract void update(Instance var1) throws Exception;

    public void addInstanceInfo(Instance ins) {
    }

    public void setInstances(Instances insts) throws Exception {
        this.m_Instances = insts;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public static void combSort11(double[] arrayToSort, int[] linkedArray) {
        int switches;
        int gap = arrayToSort.length;
        do {
            gap = (int)((double)gap / 1.3);
            switch (gap) {
                case 0: {
                    gap = 1;
                    break;
                }
                case 9: 
                case 10: {
                    gap = 11;
                    break;
                }
            }
            switches = 0;
            int top = arrayToSort.length - gap;
            for (int i = 0; i < top; ++i) {
                int j = i + gap;
                if (!(arrayToSort[i] > arrayToSort[j])) continue;
                double hold1 = arrayToSort[i];
                int hold2 = linkedArray[i];
                arrayToSort[i] = arrayToSort[j];
                linkedArray[i] = linkedArray[j];
                arrayToSort[j] = hold1;
                linkedArray[j] = hold2;
                ++switches;
            }
        } while (switches > 0 || gap > 1);
    }

    protected static int partition(double[] arrayToSort, double[] linkedArray, int l, int r) {
        double pivot = arrayToSort[(l + r) / 2];
        while (l < r) {
            while (arrayToSort[l] < pivot && l < r) {
                ++l;
            }
            while (arrayToSort[r] > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            double help = arrayToSort[l];
            arrayToSort[l] = arrayToSort[r];
            arrayToSort[r] = help;
            help = linkedArray[l];
            linkedArray[l] = linkedArray[r];
            linkedArray[r] = help;
            ++l;
            --r;
        }
        if (l == r && arrayToSort[r] > pivot) {
            --r;
        }
        return r;
    }

    public static void quickSort(double[] arrayToSort, double[] linkedArray, int left, int right) {
        if (left < right) {
            int middle = NearestNeighbourSearch.partition(arrayToSort, linkedArray, left, right);
            NearestNeighbourSearch.quickSort(arrayToSort, linkedArray, left, middle);
            NearestNeighbourSearch.quickSort(arrayToSort, linkedArray, middle + 1, right);
        }
    }

    protected class NeighborList {
        protected NeighborNode m_First;
        protected NeighborNode m_Last;
        protected int m_Length = 1;

        public NeighborList(int length) {
            this.m_Length = length;
        }

        public boolean isEmpty() {
            return this.m_First == null;
        }

        public int currentLength() {
            int i = 0;
            NeighborNode current = this.m_First;
            while (current != null) {
                ++i;
                current = current.m_Next;
            }
            return i;
        }

        public void insertSorted(double distance, Instance instance) {
            if (this.isEmpty()) {
                this.m_First = this.m_Last = new NeighborNode(distance, instance);
            } else {
                NeighborNode current = this.m_First;
                if (distance < this.m_First.m_Distance) {
                    this.m_First = new NeighborNode(distance, instance, this.m_First);
                } else {
                    while (current.m_Next != null && current.m_Next.m_Distance < distance) {
                        current = current.m_Next;
                    }
                    current.m_Next = new NeighborNode(distance, instance, current.m_Next);
                    if (current.equals(this.m_Last)) {
                        this.m_Last = current.m_Next;
                    }
                }
                int valcount = 0;
                current = this.m_First;
                while (current.m_Next != null) {
                    if (++valcount >= this.m_Length && current.m_Distance != current.m_Next.m_Distance) {
                        this.m_Last = current;
                        current.m_Next = null;
                        break;
                    }
                    current = current.m_Next;
                }
            }
        }

        public void pruneToK(int k) {
            if (this.isEmpty()) {
                return;
            }
            if (k < 1) {
                k = 1;
            }
            int currentK = 0;
            double currentDist = this.m_First.m_Distance;
            NeighborNode current = this.m_First;
            while (current.m_Next != null) {
                currentDist = current.m_Distance;
                if (++currentK >= k && currentDist != current.m_Next.m_Distance) {
                    this.m_Last = current;
                    current.m_Next = null;
                    break;
                }
                current = current.m_Next;
            }
        }

        public void printList() {
            if (this.isEmpty()) {
                System.out.println("Empty list");
            } else {
                NeighborNode current = this.m_First;
                while (current != null) {
                    System.out.println("Node: instance " + current.m_Instance + ", distance " + current.m_Distance);
                    current = current.m_Next;
                }
                System.out.println();
            }
        }

        public NeighborNode getFirst() {
            return this.m_First;
        }

        public NeighborNode getLast() {
            return this.m_Last;
        }
    }

    protected class NeighborNode {
        public Instance m_Instance;
        public double m_Distance;
        public NeighborNode m_Next;

        public NeighborNode(double distance, Instance instance, NeighborNode next) {
            this.m_Distance = distance;
            this.m_Instance = instance;
            this.m_Next = next;
        }

        public NeighborNode(double distance, Instance instance) {
            this(distance, instance, null);
        }
    }

    protected class MyHeapElement {
        public int index;
        public double distance;

        public MyHeapElement(int i, double d) {
            this.distance = d;
            this.index = i;
        }
    }

    protected class MyHeap {
        MyHeapElement[] m_heap = null;
        MyHeapElement[] m_KthNearest = null;
        int m_KthNearestSize = 0;
        int initSize = 10;

        public MyHeap(int maxSize) {
            if (maxSize % 2 == 0) {
                ++maxSize;
            }
            this.m_heap = new MyHeapElement[maxSize + 1];
            this.m_heap[0] = new MyHeapElement(0, 0.0);
        }

        public int size() {
            return this.m_heap[0].index;
        }

        public MyHeapElement peek() {
            return this.m_heap[1];
        }

        public MyHeapElement get() throws Exception {
            if (this.m_heap[0].index == 0) {
                throw new Exception("No elements present in the heap");
            }
            MyHeapElement r = this.m_heap[1];
            this.m_heap[1] = this.m_heap[this.m_heap[0].index];
            --this.m_heap[0].index;
            this.downheap();
            return r;
        }

        public void put(int i, double d) throws Exception {
            if (this.m_heap[0].index + 1 > this.m_heap.length - 1) {
                throw new Exception("the number of elements cannot exceed the initially set maximum limit");
            }
            ++this.m_heap[0].index;
            this.m_heap[this.m_heap[0].index] = new MyHeapElement(i, d);
            this.upheap();
        }

        public void putBySubstitute(int i, double d) throws Exception {
            MyHeapElement head = this.get();
            this.put(i, d);
            if (head.distance == this.m_heap[1].distance) {
                this.putKthNearest(head.index, head.distance);
            } else if (head.distance > this.m_heap[1].distance) {
                this.m_KthNearest = null;
                this.m_KthNearestSize = 0;
                this.initSize = 10;
            } else if (head.distance < this.m_heap[1].distance) {
                throw new Exception("The substituted element is smaller than the head element. put() should have been called in place of putBySubstitute()");
            }
        }

        public int noOfKthNearest() {
            return this.m_KthNearestSize;
        }

        public void putKthNearest(int i, double d) {
            if (this.m_KthNearest == null) {
                this.m_KthNearest = new MyHeapElement[this.initSize];
            }
            if (this.m_KthNearestSize >= this.m_KthNearest.length) {
                this.initSize += this.initSize;
                MyHeapElement[] temp = new MyHeapElement[this.initSize];
                System.arraycopy(this.m_KthNearest, 0, temp, 0, this.m_KthNearest.length);
                this.m_KthNearest = temp;
            }
            this.m_KthNearest[this.m_KthNearestSize++] = new MyHeapElement(i, d);
        }

        public MyHeapElement getKthNearest() {
            if (this.m_KthNearestSize == 0) {
                return null;
            }
            --this.m_KthNearestSize;
            return this.m_KthNearest[this.m_KthNearestSize];
        }

        protected void upheap() {
            int i = this.m_heap[0].index;
            while (i > 1 && this.m_heap[i].distance > this.m_heap[i / 2].distance) {
                MyHeapElement temp = this.m_heap[i];
                this.m_heap[i] = this.m_heap[i / 2];
                this.m_heap[i /= 2] = temp;
            }
        }

        protected void downheap() {
            int i = 1;
            while (2 * i <= this.m_heap[0].index && this.m_heap[i].distance < this.m_heap[2 * i].distance || 2 * i + 1 <= this.m_heap[0].index && this.m_heap[i].distance < this.m_heap[2 * i + 1].distance) {
                MyHeapElement temp;
                if (2 * i + 1 <= this.m_heap[0].index) {
                    if (this.m_heap[2 * i].distance > this.m_heap[2 * i + 1].distance) {
                        temp = this.m_heap[i];
                        this.m_heap[i] = this.m_heap[2 * i];
                        i = 2 * i;
                        this.m_heap[i] = temp;
                        continue;
                    }
                    temp = this.m_heap[i];
                    this.m_heap[i] = this.m_heap[2 * i + 1];
                    i = 2 * i + 1;
                    this.m_heap[i] = temp;
                    continue;
                }
                temp = this.m_heap[i];
                this.m_heap[i] = this.m_heap[2 * i];
                i = 2 * i;
                this.m_heap[i] = temp;
            }
        }

        public int totalSize() {
            return this.size() + this.noOfKthNearest();
        }
    }
}

