/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import moa.cluster.Clustering;
import moa.evaluation.MeasureCollection;
import moa.evaluation.MembershipMatrix;
import moa.gui.visualization.DataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class F1
extends MeasureCollection {
    @Override
    protected String[] getNames() {
        String[] names = new String[]{"F1-P", "F1-R", "Purity"};
        return names;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) {
        if (clustering.size() < 0) {
            this.addValue(0, 0.0);
            this.addValue(1, 0.0);
            return;
        }
        MembershipMatrix mm = new MembershipMatrix(clustering, points);
        int numClasses = mm.getNumClasses();
        if (mm.hasNoiseClass()) {
            --numClasses;
        }
        double F1_P = 0.0;
        double purity = 0.0;
        int realClusters = 0;
        for (int i = 0; i < clustering.size(); ++i) {
            int max_weight = 0;
            int max_weight_index = -1;
            for (int j = 0; j < numClasses; ++j) {
                if (mm.getClusterClassWeight(i, j) <= max_weight) continue;
                max_weight = mm.getClusterClassWeight(i, j);
                max_weight_index = j;
            }
            if (max_weight_index == -1) continue;
            ++realClusters;
            double precision = (double)mm.getClusterClassWeight(i, max_weight_index) / (double)mm.getClusterSum(i);
            double recall = (double)mm.getClusterClassWeight(i, max_weight_index) / (double)mm.getClassSum(max_weight_index);
            double f1 = 0.0;
            if (precision > 0.0 || recall > 0.0) {
                f1 = 2.0 * precision * recall / (precision + recall);
            }
            F1_P += f1;
            purity += precision;
            clustering.get(i).setMeasureValue("F1-P", Double.toString(f1));
        }
        if (realClusters > 0) {
            F1_P /= (double)realClusters;
            purity /= (double)realClusters;
        }
        this.addValue("F1-P", F1_P);
        this.addValue("Purity", purity);
        double F1_R = 0.0;
        for (int j = 0; j < numClasses; ++j) {
            double max_f1 = 0.0;
            for (int i = 0; i < clustering.size(); ++i) {
                double precision = (double)mm.getClusterClassWeight(i, j) / (double)mm.getClusterSum(i);
                double recall = (double)mm.getClusterClassWeight(i, j) / (double)mm.getClassSum(j);
                double f1 = 0.0;
                if (precision > 0.0 || recall > 0.0) {
                    f1 = 2.0 * precision * recall / (precision + recall);
                }
                if (!(max_f1 < f1)) continue;
                max_f1 = f1;
            }
            F1_R += max_f1;
        }
        this.addValue("F1-R", F1_R /= (double)numClasses);
    }
}

