/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import moa.cluster.CFCluster;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.clustream.ClustreamKernel;
import moa.core.Measurement;
import moa.options.IntOption;
import weka.core.DenseInstance;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WithKmeans
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    public IntOption timeWindowOption = new IntOption("horizon", 'h', "Rang of the window.", 1000);
    public IntOption maxNumKernelsOption = new IntOption("maxNumKernels", 'm', "Maximum number of micro kernels to use.", 100);
    public IntOption kernelRadiFactorOption = new IntOption("kernelRadiFactor", 't', "Multiplier for the kernel radius", 2);
    public IntOption kOption = new IntOption("k", 'k', "k of macro k-means (number of clusters)", 5);
    private int timeWindow;
    private long timestamp = -1L;
    private ClustreamKernel[] kernels;
    private boolean initialized;
    private List<ClustreamKernel> buffer;
    private int bufferSize;
    private double t;
    private int m;

    @Override
    public void resetLearningImpl() {
        this.kernels = new ClustreamKernel[this.maxNumKernelsOption.getValue()];
        this.timeWindow = this.timeWindowOption.getValue();
        this.initialized = false;
        this.buffer = new LinkedList<ClustreamKernel>();
        this.bufferSize = this.maxNumKernelsOption.getValue();
        this.t = this.kernelRadiFactorOption.getValue();
        this.m = this.maxNumKernelsOption.getValue();
    }

    @Override
    public void trainOnInstanceImpl(Instance instance) {
        int dim = instance.numValues();
        ++this.timestamp;
        if (!this.initialized) {
            if (this.buffer.size() < this.bufferSize) {
                this.buffer.add(new ClustreamKernel(instance, dim, this.timestamp, this.t, this.m));
                return;
            }
            for (int i = 0; i < this.buffer.size(); ++i) {
                this.kernels[i] = new ClustreamKernel(new DenseInstance(1.0, this.buffer.get(i).getCenter()), dim, this.timestamp, this.t, this.m);
            }
            this.buffer.clear();
            this.initialized = true;
            return;
        }
        CFCluster closestKernel = null;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.kernels.length; ++i) {
            double distance = WithKmeans.distance(instance.toDoubleArray(), this.kernels[i].getCenter());
            if (!(distance < minDistance)) continue;
            closestKernel = this.kernels[i];
            minDistance = distance;
        }
        double radius = 0.0;
        if (closestKernel.getWeight() == 1.0) {
            radius = Double.MAX_VALUE;
            double[] center = ((ClustreamKernel)closestKernel).getCenter();
            for (int i = 0; i < this.kernels.length; ++i) {
                if (this.kernels[i] == closestKernel) continue;
                double distance = WithKmeans.distance(this.kernels[i].getCenter(), center);
                radius = Math.min(distance, radius);
            }
        } else {
            radius = ((ClustreamKernel)closestKernel).getRadius();
        }
        if (minDistance < radius) {
            ((ClustreamKernel)closestKernel).insert(instance, this.timestamp);
            return;
        }
        long threshold = this.timestamp - (long)this.timeWindow;
        for (int i = 0; i < this.kernels.length; ++i) {
            if (!(this.kernels[i].getRelevanceStamp() < (double)threshold)) continue;
            this.kernels[i] = new ClustreamKernel(instance, dim, this.timestamp, this.t, this.m);
            return;
        }
        int closestA = 0;
        int closestB = 0;
        minDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.kernels.length; ++i) {
            double[] centerA = this.kernels[i].getCenter();
            for (int j = i + 1; j < this.kernels.length; ++j) {
                double dist = WithKmeans.distance(centerA, this.kernels[j].getCenter());
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                closestA = i;
                closestB = j;
            }
        }
        assert (closestA != closestB);
        this.kernels[closestA].add(this.kernels[closestB]);
        this.kernels[closestB] = new ClustreamKernel(instance, dim, this.timestamp, this.t, this.m);
    }

    @Override
    public Clustering getMicroClusteringResult() {
        if (!this.initialized) {
            return new Clustering(new Cluster[0]);
        }
        Cluster[] result = new ClustreamKernel[this.kernels.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ClustreamKernel(this.kernels[i], this.t, this.m);
        }
        return new Clustering(result);
    }

    @Override
    public Clustering getClusteringResult() {
        if (!this.initialized) {
            return new Clustering(new Cluster[0]);
        }
        return WithKmeans.kMeans_rand(this.kOption.getValue(), this.getMicroClusteringResult());
    }

    public Clustering getClusteringResult(Clustering gtClustering) {
        return WithKmeans.kMeans_gta(this.kOption.getValue(), this.getMicroClusteringResult(), gtClustering);
    }

    public String getName() {
        return "CluStreamWithKMeans " + this.timeWindow;
    }

    private static double distance(double[] pointA, double[] pointB) {
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] - pointB[i];
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    public static Clustering kMeans_gta(int k, Clustering clustering, Clustering gtClustering) {
        ArrayList<CFCluster> microclusters = new ArrayList<CFCluster>();
        for (int i = 0; i < clustering.size(); ++i) {
            if (clustering.get(i) instanceof CFCluster) {
                microclusters.add((CFCluster)clustering.get(i));
                continue;
            }
            System.out.println("Unsupported Cluster Type:" + clustering.get(i).getClass() + ". Cluster needs to extend moa.cluster.CFCluster");
        }
        int n = microclusters.size();
        assert (k <= n);
        Random random = new Random(0L);
        Cluster[] centers = new Cluster[k];
        int K = gtClustering.size();
        for (int i = 0; i < k; ++i) {
            if (i < K) {
                centers[i] = new SphereCluster(gtClustering.get(i).getCenter(), 0.0);
                continue;
            }
            int rid = random.nextInt(n);
            centers[i] = new SphereCluster(microclusters.get(rid).getCenter(), 0.0);
        }
        return WithKmeans.cleanUpKMeans(WithKmeans.kMeans(k, centers, microclusters), microclusters);
    }

    public static Clustering kMeans_rand(int k, Clustering clustering) {
        ArrayList<CFCluster> microclusters = new ArrayList<CFCluster>();
        for (int i = 0; i < clustering.size(); ++i) {
            if (clustering.get(i) instanceof CFCluster) {
                microclusters.add((CFCluster)clustering.get(i));
                continue;
            }
            System.out.println("Unsupported Cluster Type:" + clustering.get(i).getClass() + ". Cluster needs to extend moa.cluster.CFCluster");
        }
        int n = microclusters.size();
        assert (k <= n);
        Random random = new Random(0L);
        Cluster[] centers = new Cluster[k];
        for (int i = 0; i < k; ++i) {
            int rid = random.nextInt(n);
            centers[i] = new SphereCluster(microclusters.get(rid).getCenter(), 0.0);
        }
        return WithKmeans.cleanUpKMeans(WithKmeans.kMeans(k, centers, microclusters), microclusters);
    }

    /*
     * WARNING - void declaration
     */
    protected static Clustering kMeans(int k, Cluster[] centers, List<? extends Cluster> data) {
        assert (centers.length == k);
        assert (k > 0);
        int dimensions = centers[0].getCenter().length;
        ArrayList clustering = new ArrayList();
        for (int i = 0; i < k; ++i) {
            clustering.add(new ArrayList());
        }
        while (true) {
            boolean bl;
            void var6_10;
            for (Cluster cluster : data) {
                double minDistance = WithKmeans.distance(cluster.getCenter(), centers[0].getCenter());
                int closestCluster = 0;
                for (int i = 1; i < k; ++i) {
                    double distance = WithKmeans.distance(cluster.getCenter(), centers[i].getCenter());
                    if (!(distance < minDistance)) continue;
                    closestCluster = i;
                    minDistance = distance;
                }
                ((ArrayList)clustering.get(closestCluster)).add(cluster);
            }
            SphereCluster[] newCenters = new SphereCluster[centers.length];
            boolean bl2 = false;
            while (var6_10 < k) {
                newCenters[var6_10] = WithKmeans.calculateCenter((ArrayList)clustering.get((int)var6_10), dimensions);
                ((ArrayList)clustering.get((int)var6_10)).clear();
                ++var6_10;
            }
            boolean bl3 = true;
            for (int i = 0; i < k; ++i) {
                if (Arrays.equals(centers[i].getCenter(), newCenters[i].getCenter())) continue;
                bl = false;
                break;
            }
            if (bl) break;
            centers = newCenters;
        }
        return new Clustering(centers);
    }

    protected static Clustering cleanUpKMeans(Clustering kMeansResult, ArrayList<CFCluster> microclusters) {
        int k = kMeansResult.size();
        CFCluster[] converted = new CFCluster[k];
        for (CFCluster mc : microclusters) {
            double minDistance = Double.MAX_VALUE;
            int closestCluster = 0;
            for (int i = 0; i < k; ++i) {
                double distance = WithKmeans.distance(kMeansResult.get(i).getCenter(), mc.getCenter());
                if (!(distance < minDistance)) continue;
                closestCluster = i;
                minDistance = distance;
            }
            if (converted[closestCluster] == null) {
                converted[closestCluster] = (CFCluster)mc.copy();
                continue;
            }
            converted[closestCluster].add(mc);
        }
        int count = 0;
        for (int i = 0; i < converted.length; ++i) {
            if (converted[i] == null) continue;
            ++count;
        }
        Cluster[] cleaned = new CFCluster[count];
        count = 0;
        for (int i = 0; i < converted.length; ++i) {
            if (converted[i] == null) continue;
            cleaned[count++] = converted[i];
        }
        return new Clustering(cleaned);
    }

    private static SphereCluster calculateCenter(ArrayList<Cluster> assigned, int dimensions) {
        double[] result = new double[dimensions];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0.0;
        }
        if (assigned.size() == 0) {
            return new SphereCluster(result, 0.0);
        }
        for (Cluster point : assigned) {
            double[] center = point.getCenter();
            for (int i = 0; i < result.length; ++i) {
                int n = i;
                result[n] = result[n] + center[i];
            }
        }
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / (double)assigned.size();
        }
        double radius = 0.0;
        for (Cluster point : assigned) {
            double dist = WithKmeans.distance(result, point.getCenter());
            if (!(dist > radius)) continue;
            radius = dist;
        }
        SphereCluster sc = new SphereCluster(result, radius);
        sc.setWeight(assigned.size());
        return sc;
    }

    @Override
    public boolean implementsMicroClusterer() {
        return true;
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

