/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.voting;

import java.util.ArrayList;
import java.util.List;
import moa.AbstractMOAObject;
import moa.classifiers.rules.core.voting.ErrorWeightedVote;

public abstract class AbstractErrorWeightedVote
extends AbstractMOAObject
implements ErrorWeightedVote {
    private static final long serialVersionUID = -7340491298217227675L;
    protected List<double[]> votes = new ArrayList<double[]>();
    protected List<Double> errors = new ArrayList<Double>();
    protected double[] weights;

    @Override
    public void addVote(double[] vote, double error) {
        this.votes.add(vote);
        this.errors.add(error);
    }

    @Override
    public abstract double[] computeWeightedVote();

    @Override
    public double getWeightedError() {
        double weightedError = 0.0;
        if (this.weights != null && this.weights.length == this.errors.size()) {
            for (int i = 0; i < this.weights.length; ++i) {
                weightedError += this.errors.get(i) * this.weights[i];
            }
        } else {
            weightedError = -1.0;
        }
        return weightedError;
    }

    @Override
    public double[] getWeights() {
        return this.weights;
    }

    @Override
    public int getNumberVotes() {
        return this.votes.size();
    }
}

