/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import java.io.Serializable;
import java.util.ArrayList;

public class IademCommonProcedures
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static double confidence;
    private static double ln_2_div_confidence;
    private static double square_ln_2_div_confianza;

    public IademCommonProcedures(double confidence) {
        IademCommonProcedures.confidence = confidence;
        ln_2_div_confidence = Math.log(2.0 / confidence);
        square_ln_2_div_confianza = ln_2_div_confidence * ln_2_div_confidence;
    }

    public static double AverageComparitionByHoeffdingCorollary(double n, double n1, double alfa) {
        double m = 1.0 / n + 1.0 / n1;
        double bound = Math.sqrt(m * Math.log(1.0 / alfa) / 2.0);
        return bound;
    }

    public static double getConfidence() {
        return confidence;
    }

    public static void setConfidence(double confianza) {
        confidence = confianza;
        ln_2_div_confidence = Math.log(2.0 / confianza);
        square_ln_2_div_confianza = ln_2_div_confidence * ln_2_div_confidence;
    }

    public static double getIADEM_HoeffdingBound(double average, double n) {
        return IademCommonProcedures.computeBound(average, n);
    }

    public static double log(double base, double num) {
        return Math.log(num) / Math.log(base);
    }

    public static void insertLotsHoles(ArrayList<Double> lots, ArrayList<Integer> holes, double inf, double sup) {
        if (inf != sup) {
            int aux;
            int aux2;
            int i;
            int currentPos = 1;
            if (inf == 0.0) {
                for (i = 0; i < holes.size(); ++i) {
                    aux2 = holes.get(i);
                    holes.set(i, ++aux2);
                }
            } else {
                while (inf > lots.get(currentPos)) {
                    ++currentPos;
                }
                if (inf < lots.get(currentPos)) {
                    lots.add(currentPos, inf);
                    holes.add(currentPos, holes.get(currentPos - 1) + 1);
                } else {
                    aux = holes.get(currentPos);
                    holes.set(currentPos, ++aux);
                }
                for (i = currentPos + 1; i < holes.size(); ++i) {
                    aux2 = holes.get(i);
                    holes.set(i, ++aux2);
                }
            }
            while (sup > lots.get(currentPos)) {
                ++currentPos;
            }
            if (sup < lots.get(currentPos)) {
                lots.add(currentPos, sup);
                holes.add(currentPos, holes.get(currentPos - 1) - 1);
            } else if (currentPos < holes.size()) {
                aux = holes.get(currentPos);
                holes.set(currentPos, --aux);
            }
            for (i = currentPos + 1; i < holes.size(); ++i) {
                aux2 = holes.get(i);
                holes.set(i, --aux2);
            }
        }
    }

    public static double computeLevel(ArrayList<Double> lots, ArrayList<Integer> holes, double amount) {
        int currentLot;
        double level = 0.0;
        double localAmount = amount;
        if (localAmount == 0.0) {
            if (holes.size() == 1 && holes.get(0) == 0) {
                level = 0.0;
            } else {
                for (currentLot = 0; currentLot < holes.size() && holes.get(currentLot) == 0; ++currentLot) {
                }
                level = lots.get(currentLot);
            }
        } else {
            while (localAmount > 0.0) {
                double nLot;
                double lowerBound;
                double upperBound = lots.get(currentLot + 1);
                double fullAmount = (upperBound - (lowerBound = lots.get(currentLot).doubleValue())) * (nLot = (double)holes.get(currentLot).intValue());
                if (localAmount >= fullAmount) {
                    localAmount -= fullAmount;
                    level = lots.get(currentLot + 1);
                } else {
                    level += localAmount / (double)holes.get(currentLot).intValue();
                    localAmount = 0.0;
                }
                ++currentLot;
            }
        }
        return level;
    }

    public static double computeBound(double average, double n) {
        double bound;
        if (n == 0.0) {
            bound = 1.0;
        } else {
            double hoeffdingBound = Math.sqrt(1.0 / (2.0 * n) * ln_2_div_confidence);
            if (average >= 0.16666666666666666) {
                bound = hoeffdingBound;
            } else {
                double chernoffBound = (3.0 * ln_2_div_confidence + Math.sqrt(9.0 * square_ln_2_div_confianza + 12.0 * n * average * ln_2_div_confidence)) / (2.0 * n);
                bound = Math.min(Math.min(chernoffBound, hoeffdingBound), 1.0);
            }
        }
        return bound;
    }
}

