/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.functions;

import com.github.javacliparser.FloatOption;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.rules.functions.AMRulesRegressorFunction;
import moa.classifiers.rules.functions.AdaptiveNodePredictor;
import moa.core.Measurement;
import moa.options.ClassOption;

public class LowPassFilteredLearner
extends AbstractClassifier
implements AMRulesRegressorFunction {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Base learner.", AbstractClassifier.class, AdaptiveNodePredictor.class.getName());
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Alpha value. Y=Yold+alpha*(Yold+Prediction)", 0.15, 0.0, 1.0);
    protected AbstractClassifier learner;
    protected boolean hasStarted = false;
    protected double lastX;
    protected double lastY;
    protected double alpha;

    @Override
    public double getCurrentError() {
        return 0.0;
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return new double[]{this.lastY};
    }

    @Override
    public void resetLearningImpl() {
        this.hasStarted = false;
        if (this.learner != null) {
            this.learner.resetLearning();
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (!this.hasStarted) {
            this.learner = (AbstractClassifier)this.getPreparedClassOption(this.baseLearnerOption);
            this.hasStarted = true;
            this.learner.trainOnInstance(inst);
            this.lastY = this.lastX = this.learner.getVotesForInstance(inst)[0];
            this.alpha = this.alphaOption.getValue();
        } else {
            this.learner.trainOnInstance(inst);
            this.lastX = this.learner.getVotesForInstance(inst)[0];
            this.lastY += this.alpha * (this.lastX - this.lastY);
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public String getPurposeString() {
        return "Low pass filtered output (Y=Yold+alpha*(Yold+Prediction))";
    }
}

