/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.kmeanspm;

import java.io.IOException;
import java.io.Writer;
import moa.cluster.Cluster;
import moa.cluster.SphereCluster;
import moa.clusterers.kmeanspm.Metric;

public class ClusteringFeature
extends SphereCluster {
    private static final long serialVersionUID = 1L;
    private int numPoints;
    private double[] sumPoints;
    private double sumSquaredLength;

    public ClusteringFeature(double[] center, int numPoints, double[] sumPoints, double sumSquaredPoints, double radius) {
        super(center, radius, numPoints);
        assert (center.length == sumPoints.length);
        this.numPoints = numPoints;
        this.sumPoints = sumPoints;
        this.sumSquaredLength = sumSquaredPoints;
    }

    public ClusteringFeature(double[] center, double radius) {
        super(center, radius, 1.0);
        this.numPoints = 1;
        this.sumPoints = new double[center.length];
        System.arraycopy(center, 0, this.sumPoints, 0, center.length);
        this.sumSquaredLength = Metric.distanceSquared(center);
    }

    public void add(int numPoints, double[] sumPoints, double sumSquaredPoints) {
        assert (this.sumPoints.length == sumPoints.length);
        this.numPoints += numPoints;
        super.setWeight(this.numPoints);
        for (int i = 0; i < this.sumPoints.length; ++i) {
            int n = i;
            this.sumPoints[n] = this.sumPoints[n] + sumPoints[i];
        }
        this.sumSquaredLength += sumSquaredPoints;
    }

    public void merge(ClusteringFeature x) {
        assert (this.sumPoints.length == x.sumPoints.length);
        this.numPoints += x.numPoints;
        super.setWeight(this.numPoints);
        for (int i = 0; i < this.sumPoints.length; ++i) {
            int n = i;
            this.sumPoints[n] = this.sumPoints[n] + x.sumPoints[i];
        }
        this.sumSquaredLength += x.sumSquaredLength;
    }

    public Cluster toCluster() {
        double[] output = new double[this.sumPoints.length];
        System.arraycopy(this.sumPoints, 0, output, 0, this.sumPoints.length);
        int i = 0;
        while (i < output.length) {
            int n = i++;
            output[n] = output[n] / (double)this.numPoints;
        }
        return new SphereCluster(output, this.getThreshold(), this.numPoints);
    }

    public double[] toClusterCenter() {
        double[] output = new double[this.sumPoints.length + 1];
        System.arraycopy(this.sumPoints, 0, output, 1, this.sumPoints.length);
        output[0] = this.numPoints;
        int i = 1;
        while (i < output.length) {
            int n = i++;
            output[n] = output[n] / (double)this.numPoints;
        }
        return output;
    }

    public void printClusterCenter(Writer stream) throws IOException {
        stream.write(String.valueOf(this.numPoints));
        for (int j = 0; j < this.sumPoints.length; ++j) {
            stream.write(32);
            stream.write(String.valueOf(this.sumPoints[j] / (double)this.numPoints));
        }
        stream.write(System.getProperty("line.separator"));
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public void setNumPoints(int numPoints) {
        this.numPoints = numPoints;
        super.setWeight(numPoints);
    }

    public double[] getSumPoints() {
        return this.sumPoints;
    }

    public void setSumPoints(double[] sumPoints) {
        assert (this.sumPoints.length == sumPoints.length);
        this.sumPoints = sumPoints;
    }

    public double getSumSquaredLength() {
        return this.sumSquaredLength;
    }

    public void setSumSquaredLength(double sumSquaredLength) {
        this.sumSquaredLength = sumSquaredLength;
    }

    public double getThreshold() {
        return super.getRadius();
    }

    public void setThreshold(double threshold) {
        super.setRadius(threshold);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append("ClusteringFeature Object");
    }

    public double calcKMeansCosts(double[] center) {
        assert (this.sumPoints.length == center.length);
        return this.sumSquaredLength - 2.0 * Metric.dotProduct(this.sumPoints, center) + (double)this.numPoints * Metric.dotProduct(center);
    }

    public double calcKMeansCosts(double[] center, double[] point) {
        assert (this.sumPoints.length == center.length && this.sumPoints.length == point.length);
        return this.sumSquaredLength + Metric.distanceSquared(point) - 2.0 * Metric.dotProductWithAddition(this.sumPoints, point, center) + (double)(this.numPoints + 1) * Metric.dotProduct(center);
    }

    public double calcKMeansCosts(double[] center, ClusteringFeature points) {
        assert (this.sumPoints.length == center.length && this.sumPoints.length == points.sumPoints.length);
        return this.sumSquaredLength + points.sumSquaredLength - 2.0 * Metric.dotProductWithAddition(this.sumPoints, points.sumPoints, center) + (double)(this.numPoints + points.numPoints) * Metric.dotProduct(center);
    }
}

