% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTweets.R
\name{readTweets}
\alias{readTweets}
\title{Converts tweets in JSON format to R list.}
\usage{
readTweets(tweets, verbose = TRUE)
}
\arguments{
\item{tweets}{A character string naming the file where tweets are stored or the
name of the object in memory where the tweets were saved as strings.}

\item{verbose}{logical, default is \code{TRUE}, which will print in the console
the number of tweets that have been parsed.}
}
\description{
This function parses tweets downloaded using \code{filterStream},
\code{sampleStream} or \code{userStream} and returns a list.
}
\details{
This function is the first step in the \code{\link{parseTweets}} function and
is provided now as an independent function for convenience purposes. In cases
where only one field is needed, it can be faster to extract it directly from
the JSON data read in R as a list. It can also be useful to extract fields
that are not parsed by \code{\link{parseTweets}}, such as hashtags or mentions.

The total number of tweets that are parsed might be lower than the number of lines
in the file or object that contains the tweets because blank lines, deletion notices,
and incomplete tweets are ignored.
}
\examples{
## The dataset example_tweets contains 10 public statuses published
## by @twitterapi in plain text format. The code below converts the object
## into a list and extracts only the text.

data(example_tweets)
tweets.list <- readTweets(example_tweets)
only.text <- unlist(lapply(tweets.list, '[[', 'text'))
## it can be done with an explicit loop:
only.text <- c()
for (i in 1:length(tweets.list)){
   only.text[i] <- tweets.list[[i]]['text']
}
print(unlist(only.text))



}
\seealso{
\code{\link{parseTweets}}.
}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
