% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_aux.r
\name{count.feeding.links}
\alias{count.feeding.links}
\title{Count feeding links between taxa in streambugs ODE.}
\usage{
count.feeding.links(y.names, par)
}
\arguments{
\item{y.names}{same as  \code{y.names} in \code{\link{run.streambugs}}}

\item{par}{same as  \code{par} in \code{\link{run.streambugs}}}
}
\value{
Integer number of feeding links, which is a number of feeding links in a
   single habitat times number of habitats and number of reaches.
}
\description{
Count number of global "Cons" stoichiometric interactions (feeding links) between
streambugs ODE state variables (taxa) in all habitats.
}
\examples{
m <- streambugs.example.model.toy()
count.feeding.links(m$y.names, m$par)

# feeding links count does not change w/ number of habitats (nor reaches)
m <- streambugs.example.model.toy(n.Habitats=10)
count.feeding.links(m$y.names, m$par)

}
