% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_count_4.R
\name{stri_count}
\alias{stri_count}
\alias{stri_count_charclass}
\alias{stri_count_coll}
\alias{stri_count_fixed}
\alias{stri_count_regex}
\title{Count the Number of Pattern Matches}
\usage{
stri_count(str, ..., regex, fixed, coll, charclass)

stri_count_charclass(str, pattern)

stri_count_coll(str, pattern, ..., opts_collator = NULL)

stri_count_fixed(str, pattern, ..., opts_fixed = NULL)

stri_count_regex(str, pattern, ..., opts_regex = NULL)
}
\arguments{
\item{str}{character vector; strings to search in}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_regex},
\code{opts_fixed}, and so on}

\item{pattern, regex, fixed, coll, charclass}{character vector;
search patterns; for more details refer to \link{stringi-search}}

\item{opts_collator, opts_fixed, opts_regex}{a named list used to tune up
the search engine's settings; see
\code{\link{stri_opts_collator}}, \code{\link{stri_opts_fixed}},
and \code{\link{stri_opts_regex}}, respectively; \code{NULL}
for the defaults}
}
\value{
All the functions return an integer vector.
}
\description{
These functions count the number of occurrences
of a pattern in a string.
}
\details{
Vectorized over \code{str} and \code{pattern} (with recycling
of the elements in the shorter vector if necessary). This allows to,
for instance, search for one pattern in each given string,
search for each pattern in one given string,
and search for the i-th pattern within the i-th string.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.

\code{stri_count} is a convenience function.
It calls either \code{stri_count_regex},
\code{stri_count_fixed}, \code{stri_count_coll},
or \code{stri_count_charclass}, depending on the argument used.
}
\examples{
s <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit."
stri_count(s, fixed="dolor")
stri_count(s, regex="\\\\p{L}+")

stri_count_fixed(s, " ")
stri_count_fixed(s, "o")
stri_count_fixed(s, "it")
stri_count_fixed(s, letters)
stri_count_fixed("babab", "b")
stri_count_fixed(c("stringi", "123"), "string")

stri_count_charclass(c("stRRRingi", "STrrrINGI", "123"),
   c("\\\\p{Ll}", "\\\\p{Lu}", "\\\\p{Zs}"))
stri_count_charclass(" \\t\\n", "\\\\p{WHITE_SPACE}") # white space - binary property
stri_count_charclass(" \\t\\n", "\\\\p{Z}") # white-space - general category (note the difference)

stri_count_regex(s, "(s|el)it")
stri_count_regex(s, "i.i")
stri_count_regex(s, ".it")
stri_count_regex("bab baab baaab", c("b.*?b", "b.b"))
stri_count_regex(c("stringi", "123"), "^(s|1)")

}
\seealso{
Other search_count: \code{\link{stri_count_boundaries}},
  \code{\link{stringi-search}}
}
\concept{search_count}
