% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{stri_flatten}
\alias{stri_flatten}
\title{Flatten a String}
\usage{
stri_flatten(str, collapse = "", na_empty = FALSE, omit_empty = FALSE)
}
\arguments{
\item{str}{a vector of strings to be coerced to character}

\item{collapse}{a single string denoting the separator}

\item{na_empty}{single logical value; should missing values
in \code{str} be treated as empty strings?}

\item{omit_empty}{single logical value; should missing values
in \code{str} be omitted?}
}
\value{
Returns a single string, i.e., a character
vector of length 1.
}
\description{
Joins the elements of a character vector into one string.
}
\details{
The \code{stri_flatten(str, collapse='XXX')} call
is equivalent to \code{\link{paste}(str, collapse='XXX', sep='')}.

If you wish to use some more fancy (e.g., differing)
separators between flattened strings,
call \code{\link{stri_join}(str, separators, collapse='')}.

If \code{str} is not empty, then a single string is returned.
If \code{collapse} has length > 1, then only the first string
will be used.
}
\examples{
stri_flatten(LETTERS)
stri_flatten(LETTERS, collapse=',')
stri_flatten(stri_dup(letters[1:6], 1:3))
stri_flatten(c(NA, '', 'A', '', 'B', NA, 'C'), collapse=',', na_empty=TRUE, omit_empty=TRUE)

}
\seealso{
Other join: 
\code{\link{\%s+\%}()},
\code{\link{stri_dup}()},
\code{\link{stri_join_list}()},
\code{\link{stri_join}()}
}
\concept{join}
