% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{str_trim}
\alias{str_trim}
\alias{str_squish}
\title{Trim whitespace from a string}
\usage{
str_trim(string, side = c("both", "left", "right"))

str_squish(string)
}
\arguments{
\item{string}{A character vector.}

\item{side}{Side on which to remove whitespace (left, right or both).}
}
\value{
A character vector.
}
\description{
\code{str_trim()} removes whitespace from start and end of string; \code{str_squish()}
also reduces repeated whitespace inside a string.
}
\examples{
str_trim("  String with trailing and leading white space\t")
str_trim("\n\nString with trailing and leading white space\n\n")

str_squish("  String with trailing,  middle, and leading white space\t")
str_squish("\n\nString with excess,  trailing and leading white   space\n\n")
}
\seealso{
\code{\link[=str_pad]{str_pad()}} to add whitespace
}
