% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unused-letters.R
\name{unused_letters}
\alias{unused_letters}
\title{Find letters not used in strings}
\usage{
unused_letters(s, n = 1, avoid_strifrtf_internal = TRUE,
  as_number = FALSE, as_vector = FALSE)
}
\arguments{
\item{s}{character vector}

\item{n}{number of letters to return}

\item{avoid_strifrtf_internal}{If \code{TRUE}, letters used in the package's internal process are also regarded as "used".}

\item{as_number}{if \code{TRUE}, return unicode numbers instead of letters itself}

\item{as_vector}{if \code{FALSE} (and \code{as_number} is \code{FALSE}), return
a single concatenated character, otherwise returns a character vector}
}
\value{
unsed characters, format depends on \code{as_number} and \code{as_vector} arguments
}
\description{
Returns letters not used in strings
}
\details{
This function can be useful when some special characters must be
temporarily converted to another letter without being confused with the same letters used elsewhere.

Letters are first searched from \code{\\u0001} upto \code{\\uffff}.
Do not specify too large \code{n}; An error is raised if a sufficient number of unsed letters are not found.
}
