% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.RegnTables.R
\name{printRegnTables}
\alias{printRegnTables}
\title{Print estimated regression tables}
\usage{
printRegnTables(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{the estimated regression tables from estimateRegnTables()}

\item{digits}{minimum number of significant digits to be used for most numbers.}

\item{signif.stars}{logical; if TRUE, P-values are additionally encoded 
visually as ‘significance stars’ in order to help scanning of long 
coefficient tables. It defaults to the show.signif.stars slot of options.}

\item{...}{other arguments suitable for stats::printCoefmat()}
}
\value{
Prints estimated regression tables from estimateRegnTables() to console
}
\description{
Prints estimated regression tables from estimateRegnTables()
}
\examples{
\donttest{
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
X <- model.matrix(~1+out$meta$treatment + out$meta$pid_rep + 
out$meta$treatment * out$meta$pid_rep)[,-1]
X_seed <- as.matrix(out$meta$treatment)
## low max iteration number just for testing
sts_estimate <- sts(X, X_seed, out, numTopics = 3, verbose = FALSE, 
parallelize = FALSE, maxIter = 3, initialization = 'anchor')
regn_tables <- estimateRegnTables(sts_estimate$alpha, mu = sts_estimate$mu, 
sigma = sts_estimate$sigma, X = X)
printRegnTables(regn_tables)
}
}
