% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voxel_select.R
\name{voxel_select}
\alias{voxel_select}
\title{Select Potential Voxels}
\usage{
voxel_select(normalized_baseline_t2, normalized_follow_up_t2, brain_mask,
  sigma = diag(3, 3), ksize = 5)
}
\arguments{
\item{normalized_baseline_t2}{Baseline T2 image, array or object class nifti that}

\item{normalized_follow_up_t2}{Followup T2 image, array or object class nifti that}

\item{brain_mask}{A 3D 0-1 mask that delimits where the smoothing occurs, passed to \code{\link{GaussSmoothArray}}}

\item{sigma}{Sigma passed to \code{\link{GaussSmoothArray}}}

\item{ksize}{Kernel size passed to \code{\link{GaussSmoothArray}}}
}
\value{
Array or object class nifti depending on imput iamges
}
\description{
Takes the difference in T2 images, smoothes this 
difference, and then finds voxels greater than one SD of the 
smooothed mask as potential voxels and returns it
}
\seealso{
GaussSmoothArray
}
\keyword{Selection}
\keyword{Voxel}

