% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_ThreeStage.R
\name{DSC_ThreeStage}
\alias{DSC_ThreeStage}
\title{Construct Subspace Stream Clusterers}
\usage{
DSC_ThreeStage(macro, micro)
}
\arguments{
\item{macro}{a dsc object representing a macroclustering}

\item{micro}{a dsc object representing a micro clustering, which can be
obtained by calling e.g. \link{DSC_subspaceCluStream}.}
}
\description{
This function allows you to combine a micro clustering algorithm and a macro 
clustering algorithm into a single object that can then be used as a normal 
DSC object. This object can then be used with e.g. \link{update} to produce a
micro clustering of a stream.
}
\details{
The microclustering component is implemented as usual, i.e. a
\emph{DSC_ThreeStage} object with a \link{DSC_subspaceCluStream}
microclustering component will produce the same microclusters that a normal
\emph{CluStream} would have produced. This is the first of the three stages.

Whenever a macro clustering is requested, Multivariate Gaussian Distributions 
around the positions of the microclusters are used to simulate the original 
stream. This is the second stage.

Then the macro clustering is performed on the points generated by these
distributions using the selected macro clustering algorithm. This is the third
stage.

Possible choices for the micro clusterer are \link{DSC_subspaceDenStream} and 
\link{DSC_subspaceCluStream}. Possible macro clusterers are \link{DSC_clique},
\link{DSC_p3c}, \link{DSC_proclus} and \link{DSC_subclu}. Other clusterers are
currently not supported.
}

