% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_plot.R
\name{interactive_plot}
\alias{interactive_plot}
\title{Plot a list of CUSUM charts (interactive)}
\usage{
interactive_plot(x, unit_names, scale = FALSE, group_by = c("none", "unit",
  "type"), highlight = FALSE, manual_colors = c(), ...)
}
\arguments{
\item{x}{A list with each item containing one cumulative sum chart.}

\item{unit_names}{The unit names to be displayed in the interactive plot.
Must be of equal length as \code{x}.}

\item{scale}{Should charts be scaled with respect to their control limit/
maximum value? Default is \code{FALSE}.}

\item{group_by}{Character indicating how to group the CUSUM charts in the plot.
Possible values are \code{c("none", "unit", "type")}. Default is \code{"none"}.}

\item{highlight}{Should charts be highlighted on hover? Default is \code{FALSE}.}

\item{manual_colors}{A character vector specifying which colors to use
for the units in the data. By default, the "Dark2" color set from
\code{\link[RColorBrewer:brewer.pal]{brewer.pal()}} will be used.}

\item{...}{Further plotting parameters}
}
\value{
An interactive plot will be produced in the current graphics device.
For more information on the possibilities for interaction, see \url{https://plotly.com/r/}.
}
\description{
Create an interactive plot visualizing a combination of control charts
which can be created using this package.
}
\examples{
\donttest{
require(survival)
#Extract data to construct CUSUM charts on
tdat <- subset(surgerydat, unit == 1 & entrytime < 365)
tdat2 <- subset(surgerydat, unit == 2 & entrytime < 365)

#Determine model parameters
followup <- 100
tcbaseh <- function(t) chaz_exp(t, lambda = 0.01)
exprfit <- as.formula("Surv(survtime, censorid) ~ age + sex + BMI")
tcoxmod <- coxph(exprfit, data= surgerydat)
exprfitber <- as.formula("(survtime <= followup) & (censorid == 1)~ age + sex + BMI")
glmmodber <- glm(exprfitber, data = surgerydat, family = binomial(link = "logit"))


#Construct the charts
cgr <- cgr_cusum(data = tdat, coxphmod = tcoxmod, cbaseh = tcbaseh, pb = TRUE)
cgr$h <- 8.29
bk <- bk_cusum(data = tdat, theta = log(2), coxphmod = tcoxmod, cbaseh = tcbaseh, pb = TRUE)
bk$h <- 6.23
bercus <- bernoulli_cusum(data = subset(surgerydat, unit == 1), glmmod = glmmodber,
followup = followup, theta = log(2))
bercus$h <- 3.36
bk2 <- bk_cusum(data = tdat2, theta = log(2), coxphmod = tcoxmod, cbaseh = tcbaseh, pb = TRUE)
bk2$h <- 6.23

#Create the plot
interactive_plot(list(cgr, bk, bercus, bk2), unit_names =
c("hosp1", "hosp1", "hosp1", "hosp2"))
}
}
\seealso{
\code{\link[success]{cgr_cusum}}, \code{\link[success]{bk_cusum}}, \code{\link[success]{bernoulli_cusum}}, \code{\link[success]{funnel_plot}}
}
