% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudokuAlt.R
\name{solveGame}
\alias{solveGame}
\title{Solve a Sudoku Game}
\usage{
solveGame(game)
}
\arguments{
\item{game}{The game to be solved}
}
\value{
A solved sudoku game object if one found, or NULL if no
solution exists.  The original game is attached as an attribute.
}
\description{
Solve a Sudoku Game
}
\details{
Given a sudoku game to be solved, find the solution.  IMPORTANT:
games are represented as n^2 x n^2 character matrices, using 1-9 for
n=2 or 3, and LETTERS[1:(n^2)] for n = 4 or 5.
}
\examples{
set.seed(1234)
(g <- makeGame(3))
(sg <- solveGame(g))
plot(sg)
g <- emptyGame(4)  # construct a patterned game
diag(g) <- LETTERS[1:16]
sg <- solve(g)
plot(sg)
}
\author{
Bill Venables
}
