\name{FFGAS}
\alias{FFGAS}
\alias{sumSTAAR}
\title{Flexible Framework for Gene-based Association Study}
\description{
STAAR procedure developed by Li et al. (2020) adapted to use on summary statistics, with extentions
}
\usage{

FFGAS(score.file, gene.file, genes = 'all', cor.path = 'cor/',
tests = c('BT', 'SKAT', 'ACAT'), beta.par.matrix = rbind(c(1, 1), c(1, 25)), 
prob.causal = NA, phred = FALSE, n = NA, write.file = FALSE, quiet = FALSE)

sumSTAAR(score.file, gene.file, genes = 'all', cor.path = 'cor/',
tests = c('BT', 'SKAT', 'ACAT'), beta.par.matrix = rbind(c(1, 1), c(1, 25)), 
prob.causal = paste0('PROB', 1:10), phred = TRUE, n = NA, write.file = FALSE,
quiet = FALSE)

}

\arguments{
	\item{score.file}{name of data file generated by \code{prep.score.files()}.}

	\item{gene.file}{can be a name of a custom text file listing genes in refFlat format. Values "hg19" and "hg38"
	can be set to use default gene files containing protein-coding genes with start and stop positions from corresponding build.
	Mind that the same build should be used in \code{score.file} and \code{gene.file}.}

	\item{genes}{character vector of gene names to be analyzed. Can be "chr1", "chr2" etc. to analyze
	all genes on a corresponding chromosome. If not set, function will
	attempt to analyze all genes listed in \code{gene.file}.}

	\item{cor.path}{path to a folder with correlation matrix files (one file per each gene to be analyzed).
	Correlation matrices in text format are allowed, though ".RData" is preferable as computationally efficient.
	Each file should contain a square matrix with correlation coefficients (r) between genetic variants
	of a gene. An example of correlation file format:\cr
	"snpname1" "snpname2" "snpname3" ...\cr
	"snpname1" 1 0.018 -0.003 ...\cr
	"snpname2" 0.018 1 0.081 ...\cr
	"snpname3" -0.003 0.081 1 ...\cr
	...\cr
	If genotypes are available, matrices can be generated as follows:\cr
	\code{cor.matrix <- cor(g)}\cr
	\code{save(cor.matrix, file = paste0(geneName, ".RData"))}\cr
	where \code{g} is a genotype matrix (nsample x nvariants) for a given gene with genotypes coded as 0, 1, 2
	(coding should be exactly the same that was used to generate GWAS statistics).\cr
	If genotypes are not available, correlations can be approximated through reference samples.
	Reference matrices from 1KG European sample can be downloaded at http://mga.bionet.nsc.ru/sumFREGAT/.\cr
	Names of correlation files should be constructed as "geneName.RData" (e.g. "ABCG1.RData", "ADAMTS1.RData", etc.)
	for ".RData" format or "geneName.txt" for text format.\cr
	Example corfiles can be found as:\cr
	system.file("testfiles/CFH.cor", package = "sumFREGAT")\cr
	system.file("testfiles/CFH.RData", package = "sumFREGAT")\cr
	}
	
	\item{tests}{a character vector with gene-based methods to be applied. By default, three methods are used: 'BT', 'SKAT',
	and 'ACAT'. Other weighted tests ('PCA', 'FLM') can be included in both \code{sumSTAAR()} and \code{FFGAS()}. Tests that do not imply
	weighting ('MLR', 'simpleM', 'minP', 'sumchi') can be used in \code{FFGAS()} to be calculated once and combined along with other tests
	into the total FFGAS p-value. 'SKATO' can be used in \code{FFGAS()} with different beta weighting modes (probabilities will not be applied).
	ACAT performs with \code{gen.var.weights = "af"} for consistency with STAAR.}

	\item{beta.par.matrix}{an (n x 2) matrix with rows corresponding to n \code{beta.par} values used sequentially. Default value
	\code{rbind(c(1, 1), c(1, 25))} means that \code{beta.par = c(1, 1)} and \code{beta.par = c(1, 25)} will be applied. \code{beta.par}
	are two positive numeric shape parameters in the beta distribution to assign weights 
	for each genetic variant as a function of minor allele frequency (MAF).}

	\item{prob.causal}{a character vector to define a set of annotations to be used. Annotations should be initially passed to
	\code{prep.score.files} (see \code{prep.score.files()} function) as input file columns "PROB", "PROB1", "PROB2", "PROB3" etc.
	The same naming should be used for \code{prob.causal} argument.}

	\item{phred}{a logical value indicating whether probabilities are in PHRED scale. If \code{TRUE} (default for \code{sumSTAAR()}), PHRED-to-probability
	transformation will be performed for values indicated in \code{prob.causal}. In \code{FFGAS()}), probabilities are treated directly
	as probabilities by default (\code{phred = FALSE}).}

	\item{n}{size of the sample on which summary statistics were obtained. Should be assigned if 'PCA', 'FLM' or 'MLR'
	are included in \code{tests}.}

	\item{write.file}{output file name. If specified, output for all tests (as it proceeds) will be written 
	to corresponding files.}

	\item{quiet}{\code{quiet = TRUE} suppresses excessive output from reading vcf file genewise.}

}
\details{
The STAAR procedure has been recently proposed by Li et al. (2020) and described in detail therein. It calculates
a set of P values using a range of gene-based tests, beta distribution weights parameters, and weighting by each of
10 functional annotations. The P values are then combined using Cauchy method (see \code{ACATO()} function and Liu, Y. et al., (2019)).
}
\value{
	
	\code{FFGAS()} returns a data table with a single P value for each test (combinations of differently weighted and unweighted
	iterations of the same test) and a total FFGAS P value. ACAT-O method is used to combine P values (Liu, Y. et al., 2019).\cr
	
	\code{sumSTAAR()} generates a data frame of size (n.genes x (n.tests x n.beta.pars x (n.annotations + 1) + n.tests + 2)) containing P values
	for combined tests and all individual tests. The output is analogous to that of original STAAR procedure. For example,
	by default, the output will contain columns:\cr\cr
	gene # gene symbol\cr
	BT.1.1.PROB0 # P value for burden test with beta.par = c(1, 1) and no annotations\cr
	BT.1.1.PROB1 # P value for burden test with beta.par = c(1, 1) and weighted by first annotation\cr
	BT.1.1.PROB2 # P value for burden test with beta.par = c(1, 1) and weighted by second annotation\cr
	...\cr
	BT.1.1.PROB10 # P value for burden test with beta.par = c(1, 1) and weighted by tenth annotation\cr
	BT.1.1.STAAR # combined P value of all burden tests with beta.par = c(1, 1)\cr
	BT.1.25.PROB0 # P value for burden test with beta.par = c(1, 25) and no annotations\cr
	BT.1.25.PROB1 # P value for burden test with beta.par = c(1, 25) and weighted by first annotation\cr
	...\cr
	BT.1.25.PROB10 # P value for burden test with beta.par = c(1, 25) and weighted by tenth annotation\cr
	BT.1.25.STAAR # combined P value of all burden tests with beta.par = c(1, 25)\cr
	SKAT.1.1.PROB0 # P value for SKAT with beta.par = c(1, 1) and no annotations\cr
	SKAT.1.1.PROB1 # P value for SKAT with beta.par = c(1, 1) and weighted by first annotation\cr
	...\cr
	SKAT.1.1.PROB10 # P value for SKAT with beta.par = c(1, 1) and weighted by tenth annotation\cr
	SKAT.1.1.STAAR # combined P value of all SKATs with beta.par = c(1, 1)\cr
	SKAT.1.25.PROB0 # P value for SKAT with beta.par = c(1, 25) and no annotations\cr
	...\cr
	SKAT.1.25.PROB10 # P value for SKAT with beta.par = c(1, 25) and weighted by tenth annotation\cr
	SKAT.1.25.STAAR # combined P value of all SKATs with beta.par = c(1, 25)\cr
	ACAT.1.1.PROB0 # P value for ACAT with beta.par = c(1, 1) and no annotations\cr
	ACAT.1.1.PROB1 # P value for ACAT with beta.par = c(1, 1) and weighted by first annotation\cr
	...\cr
	ACAT.1.1.PROB10 # P value for ACAT with beta.par = c(1, 1) and weighted by tenth annotation\cr
	ACAT.1.1.STAAR # combined P value of all ACATs with beta.par = c(1, 1)\cr
	ACAT.1.25.PROB0 # P value for ACAT with beta.par = c(1, 25) and no annotations\cr
	...\cr
	ACAT.1.25.PROB10 # P value for ACAT with beta.par = c(1, 25) and weighted by tenth annotation\cr
	ACAT.1.25.STAAR # combined P value of all ACATs with beta.par = c(1, 25)\cr
	sumSTAAR.ACAT_O # combined P value of all 'PROB0' gene-based tests (without weighting by annotations)\cr
	sumSTAAR.STAAR_O # combined P value of all gene-based tests\cr
}
\references{
	Li X., et al. (2020) Dynamic incorporation of multiple in silico functional annotations empowers rare variant association analysis of large whole-genome sequencing studies at scale. Nature Genetics. DOI: 10.1038/s41588-020-0676-4.\cr
	Liu Y. et al. (2019) ACAT: a fast and powerful p value combination method for rare-variant analysis in sequencing studies. Am. J. Hum. Genet. 104, 410-421.\cr

}
\examples{

cor.path <- system.file("testfiles/", package = "sumFREGAT")
score.file <- system.file("testfiles/CFH.prob.vcf.gz",
	package = "sumFREGAT")
FFGAS(score.file, prob.causal = "PROB", gene.file = "hg19", genes = "CFH", cor.path, quiet = TRUE)

\dontrun{

score.file <- system.file("testfiles/CFH.prob.phred.vcf.gz",
	package = "sumFREGAT")
res <- sumSTAAR(score.file, gene.file = "hg19", genes = "CFH", cor.path, quiet = TRUE)
}
}
