% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\alias{stview}
\title{view}
\usage{
view(x, method = "viewer", file = "", append = FALSE,
  report.title = NA, table.classes = NA, 
  bootstrap.css = st_options("bootstrap.css"), 
  custom.css = st_options("custom.css"), silent = FALSE, 
  footnote = st_options("footnote"),
  max.tbl.height = Inf,
  collapse = 0,
  escape.pipe = st_options("escape.pipe"), \dots)
}
\arguments{
\item{x}{A summarytools object that was generated with \code{\link{freq}},
\code{\link{descr}}, \code{\link{ctable}} or \code{\link{dfSummary}}.}

\item{method}{One of \dQuote{pander}, \dQuote{viewer}, \dQuote{browser}, or
\dQuote{render}. For \code{print()}, default is \dQuote{pander}; for
\code{view()}, default is \dQuote{viewer}. If \dQuote{viewer} is used
outside \emph{RStudio}, \dQuote{browser} will be used instead. Use
\dQuote{render} if function is called from an Rmd document.}

\item{file}{File name to write output to. Defaults to \dQuote{}.}

\item{append}{Logical. When \code{file} argument is supplied, this indicates
whether to append output to existing file. \code{FALSE} by default.}

\item{report.title}{For \emph{html} reports, this goes into the
\code{<title>} tag. Defaults to \code{NA}, in which case \code{<title>}
will be generic.}

\item{table.classes}{Character.  Additional classes to assign to output
tables. All \emph{Bootstrap css} classes can be used. It also allows
user-defined classes (see custom.css parameter). See \emph{details}
section. \code{NA} by default.}

\item{bootstrap.css}{Logical. Set to \code{FALSE} to omit
\emph{Bootstrap css}. \code{TRUE} by default. To change this default value
globally, see \code{\link{st_options}}.}

\item{custom.css}{Path to a user-defined \emph{.css} file. Classes defined in
this file can be used in the \code{table.classes} parameter. \code{NA} by
default. To change this default value globally, see
\code{\link{st_options}}.}

\item{silent}{Hide console messages (such as ignored variables or \code{NaN}
to \code{NA} transformations).}

\item{footnote}{footnote in \emph{html} output. When set to \dQuote{default},
this is the package name and version, R version, and current date). Has no
effect when \code{method} is \dQuote{pander}. Set to \dQuote{default},
provide your own text, or set to \code{NA} to omit. To change this default
value globally, see \code{\link{st_options}}.}

\item{max.tbl.height}{Maximum table height (in pixels) allowed in rendered
\code{dfSummary()} tables. When this argument is used, results will show up
in a \code{<div>} with the specified height and a scroll bar. Intended
to be used in \emph{Rmd} documents. Has no effect when \code{method} is
\dQuote{pander}. \code{Inf} by default.}

\item{collapse}{Numeric. \code{0} by default. Set to \code{1} to make
\code{freq()} sections collapsible (when clicking on the variable name).
Future versions might provide alternate collapsing options.}

\item{escape.pipe}{Logical. Set to \code{TRUE} when using \code{style='grid'}
and \code{file} argument is supplied if the intent is to generate a text
file that can be converted to other formats using \emph{Pandoc}. To change
this default value globally, see \code{\link{st_options}}.}

\item{...}{Additional arguments can be used to override parameters stored
as attributes in the object being printed. See \emph{Details} section.}
}
\description{
Visualize results in RStudio's Viewer or in Web Browser
}
\details{
Creates \emph{html} outputs and opens them in the Viewer, in a browser or
renders the \emph{html} code appropriate for \emph{Rmarkdown} documents. 

For objects of class \dQuote{summarytools}, this function is simply
a wrapper around \code{\link{print.summarytools}} with \emph{method} set to
\dQuote{viewer}.
 
Objects of class \dQuote{by} or \dQuote{list} are dispatched to the present
function, as it can manage multiple objects, whereas 
\code{\link{print.summarytools}} can only manage one object at a time.
}
