% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctable.R
\name{ctable}
\alias{ctable}
\title{Cross-Tabulation}
\usage{
ctable(
  x,
  y,
  prop = st_options("ctable.prop"),
  useNA = "ifany",
  totals = st_options("ctable.totals"),
  style = st_options("style"),
  round.digits = st_options("ctable.round.digits"),
  justify = "right",
  plain.ascii = st_options("plain.ascii"),
  headings = st_options("headings"),
  display.labels = st_options("display.labels"),
  split.tables = Inf,
  na.val = st_options("na.val"),
  dnn = c(substitute(x), substitute(y)),
  chisq = FALSE,
  OR = FALSE,
  RR = FALSE,
  weights = NA,
  rescale.weights = FALSE,
  ...
)
}
\arguments{
\item{x}{First categorical variable - values will appear as row names.}

\item{y}{Second categorical variable - values will appear as column names.}

\item{prop}{Character. Indicates which proportions to show: \dQuote{r} 
(rows, default), \dQuote{c} (columns), \dQuote{t} (total), or \dQuote{n}
(none). Default value can be changed using \code{\link{st_options}},
option \code{ctable.prop}.}

\item{useNA}{Character. One of \dQuote{ifany} (default), \dQuote{no}, or 
\dQuote{always}. This argument is passed on \sQuote{as is} to 
\code{\link[base]{table}}, or adapted for \code{\link[stats]{xtabs}} when
weights are used.}

\item{totals}{Logical. Show row and column totals. Defaults to
\code{TRUE} but can be set globally with \code{\link{st_options}}, option 
\code{ctable.totals}.}

\item{style}{Character. Style to be used by \code{\link[pander]{pander}}. One
of \dQuote{simple} (default), \dQuote{grid}, \dQuote{rmarkdown}, or
\dQuote{jira}. Can be set globally with \code{\link{st_options}}.}

\item{round.digits}{Numeric. Number of significant digits to keep. Defaults
to \code{1}. To change this default value, use \code{\link{st_options}},
option \code{ctable.round.digits}.}

\item{justify}{Character. Horizontal alignment; one of \dQuote{l} (left),
\dQuote{c} (center), or \dQuote{r} (right, default).}

\item{plain.ascii}{Logical. Used by \code{\link[pander]{pander}}; when
\code{TRUE}, no markup characters are generated (useful when printing
to console). Defaults to \code{TRUE} unless \code{style = 'rmarkdown'},
in which case it is set to \code{FALSE} automatically. To change the 
default value globally, use \code{\link{st_options}}.}

\item{headings}{Logical. Show heading section. \code{TRUE} by default; can be
set globally with \code{\link{st_options}}.}

\item{display.labels}{Logical. Display data frame label in the heading 
section. \code{TRUE} by default, can be changed globally with
\code{\link{st_options}}.}

\item{split.tables}{Numeric. \code{\link[pander]{pander}} argument that 
specifies how many characters wide a table can be. \code{Inf} by default.}

\item{na.val}{Character. For factors and character vectors, consider this
value as \code{NA}. Ignored if there are actual NA values or if it matches
no value / factor level in the data. \code{NULL} by default.}

\item{dnn}{Character vector. Variable names to be used in output table. In
most cases, setting this parameter is not required as the names are 
automatically generated.}

\item{chisq}{Logical. Display chi-square statistic along with p-value.}

\item{OR}{Logical or numeric. Set to \code{TRUE} to show odds ratio with 95%
confidence interval, or specify confidence level explicitly (\emph{e.g.},
\code{.90}). CI's are calculated using Wald's method of normal approximation.}

\item{RR}{Logical or numeric. Set to \code{TRUE} to show risk ratio (also
called \emph{relative risk} with 95% confidence interval, or specify
confidence level explicitly (\emph{e.g.} \code{.90}). CI's are 
calculated using Wald's method of normal approximation.}

\item{weights}{Numeric. Vector of weights; must have the same length as
\code{x}.}

\item{rescale.weights}{Logical. When \code{TRUE}, a global constant is
applied so that the sum of counts equals \code{nrow(x)}. \code{FALSE} by
default.}

\item{\dots}{Additional arguments passed to \code{\link[pander]{pander}} or
\code{\link[base]{format}}.}
}
\value{
A list containing two matrices, \emph{cross_table} and 
  \emph{proportions}. The \emph{print} method takes care of assembling 
  figures from those matrices into a single table. The returned object is
  of classes \dQuote{\emph{summarytools}} and \dQuote{\emph{list}}, unless 
  \code{\link[summarytools]{stby}} is used, in which case we have an
  object of class \dQuote{\emph{stby}}.
}
\description{
Cross-tabulation for a pair of categorical variables with either
row, column, or total proportions, as well as marginal sums. Works with
numeric, character, as well as factor variables.
}
\note{
Markdown does not fully support multi-header tables;
  until such support is available, the recommended way to display 
  cross-tables in .Rmd documents is to use `method=render`. See package
  vignettes for examples.
}
\examples{
data("tobacco")
ctable(tobacco$gender, tobacco$smoker)

# Use with() to simplify syntax
with(tobacco, ctable(smoker, diseased))

# Show column proportions, without totals
with(tobacco, ctable(smoker, diseased, prop = "c", totals = FALSE))

# Simple 2 x 2 table with odds ratio and risk ratio
with(tobacco, ctable(gender, smoker, totals = FALSE, headings = FALSE, prop = "n",
                     OR = TRUE, RR = TRUE))

# Grouped cross-tabulations
with(tobacco, stby(data = list(x = smoker, y = diseased), 
                   INDICES = gender, FUN = ctable))


\dontrun{
ct <- ctable(tobacco$gender, tobacco$smoker)

# Show html results in browser
print(ct, method = "browser")

# Save results to html file
print(ct, file = "ct_gender_smoker.html")

# Save results to text file
print(ct, file = "ct_gender_smoker.txt")
}
}
\seealso{
\code{\link[base]{table}}, \code{\link[stats]{xtabs}}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{category}
\keyword{classes}
