% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MauchlySphericityTest.R
\name{MauchlySphericityTest}
\alias{MauchlySphericityTest}
\title{MauchlySphericityTest}
\usage{
MauchlySphericityTest(dta, cols)
}
\arguments{
\item{dta}{A data frame containing within-subject measures, one participant per line;}

\item{cols}{A vector indicating the columns containing the measures.}
}
\value{
p the p-value of the null hypothesis that the data are spherical.
}
\description{
Performs a test of sphericity on a dataframe with
  multiple measures, one subject per line. It assesses the significance of the 
  null hypothesis that the covariance matrix is spherical. 
  This test is described in \insertCite{a10}{superb}
}
\examples{
# creates a small data frames with 4 subject's scores for 5 measures:
dta <- data.frame(cbind(
        col1 <- c(3., 6., 2., 2., 5.),
        col2 <- c(4., 5., 4., 4., 3.),
        col3 <- c(2., 7., 7., 8., 6.),
        col4 <- c(6., 8., 4., 6., 5.)
    ))
# performs the test (here p = 0.5824)
MauchlySphericityTest(dta)
# 0.582443

}
\references{
\insertAllCited{}
}
