% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomForest.R
\name{RFTrainer}
\alias{RFTrainer}
\title{Random Forest Trainer}
\description{
Trains a random forest model.
}
\details{
Trains a Random Forest model. A random forest is a meta estimator that fits a number of decision tree classifiers on various sub-samples of the dataset and use averaging to improve the predictive accuracy and control over-fitting.
This implementation uses ranger R package which provides faster model training.
}
\examples{

## ------------------------------------------------
## Method `RFTrainer$new`
## ------------------------------------------------

data("iris")
bst <- RFTrainer$new(n_estimators=10,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)

## ------------------------------------------------
## Method `RFTrainer$fit`
## ------------------------------------------------

data("iris")
bst <- RFTrainer$new(n_estimators=10,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
bst$fit(iris, 'Species')

## ------------------------------------------------
## Method `RFTrainer$predict`
## ------------------------------------------------

data("iris")
bst <- RFTrainer$new(n_estimators=10,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
bst$fit(iris, 'Species')
predictions <- bst$predict(iris)

## ------------------------------------------------
## Method `RFTrainer$get_importance`
## ------------------------------------------------

data("iris")
bst <- RFTrainer$new(n_estimators=50,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
bst$fit(iris, 'Species')
predictions <- bst$predict(iris)
bst$get_importance()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n_estimators}}{the number of trees in the forest, default= 100}

\item{\code{max_features}}{the number of features to consider when looking for the best split.
Possible values are \code{auto(default)} takes sqrt(num_of_features),
    \code{sqrt} same as auto,
    \code{log} takes log(num_of_features),
    \code{none} takes all features}

\item{\code{max_depth}}{the maximum depth of each tree}

\item{\code{min_node_size}}{the minumum number of samples required to split an internal node}

\item{\code{criterion}}{the function to measure the quality of split. For classification, \code{gini} is used which
is a measure of gini index. For regression, the \code{variance} of responses is used.}

\item{\code{classification}}{whether to train for classification (1) or regression (0)}

\item{\code{verbose}}{show computation status and estimated runtime}

\item{\code{seed}}{seed value}

\item{\code{class_weights}}{weights associated with the classes for sampling of training observation}

\item{\code{always_split}}{vector of feature names to be always used for splitting}

\item{\code{importance}}{Variable importance mode, one of 'none', 'impurity', 'impurity_corrected', 'permutation'. The 'impurity' measure is the Gini index for classification, the variance of the responses for regression. Defaults to "impurity"}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RFTrainer$new()}}
\item \href{#method-fit}{\code{RFTrainer$fit()}}
\item \href{#method-predict}{\code{RFTrainer$predict()}}
\item \href{#method-get_importance}{\code{RFTrainer$get_importance()}}
\item \href{#method-clone}{\code{RFTrainer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFTrainer$new(
  n_estimators,
  max_depth,
  max_features,
  min_node_size,
  classification,
  class_weights,
  always_split,
  verbose,
  save_model,
  seed,
  importance
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_estimators}}{integer, the number of trees in the forest, default= 100}

\item{\code{max_depth}}{integer, the maximum depth of each tree}

\item{\code{max_features}}{integer, the number of features to consider when looking for the best split.
Possible values are \code{auto(default)} takes sqrt(num_of_features),
    \code{sqrt} same as auto,
    \code{log} takes log(num_of_features),
    \code{none} takes all features}

\item{\code{min_node_size}}{integer, the minumum number of samples required to split an internal node}

\item{\code{classification}}{integer, whether to train for classification (1) or regression (0)}

\item{\code{class_weights}}{weights associated with the classes for sampling of training observation}

\item{\code{always_split}}{vector of feature names to be always used for splitting}

\item{\code{verbose}}{logical, show computation status and estimated runtime}

\item{\code{save_model}}{logical, whether to save model}

\item{\code{seed}}{integer, seed value}

\item{\code{importance}}{Variable importance mode, one of 'none', 'impurity', 'impurity_corrected', 'permutation'. The 'impurity' measure is the Gini index for classification, the variance of the responses for regression. Defaults to "impurity"}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new `RFTrainer` object.
}

\subsection{Returns}{
A `RFTrainer` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data("iris")
bst <- RFTrainer$new(n_estimators=10,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFTrainer$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{data.frame containing train features}

\item{\code{y}}{character, name of the target variable}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Trains the random forest model
}

\subsection{Returns}{
NULL, trains and saves the model in memory
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data("iris")
bst <- RFTrainer$new(n_estimators=10,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
bst$fit(iris, 'Species')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFTrainer$predict(df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{data.frame containing test features}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return predictions from random forest model
}

\subsection{Returns}{
a vector containing predictions
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data("iris")
bst <- RFTrainer$new(n_estimators=10,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
bst$fit(iris, 'Species')
predictions <- bst$predict(iris)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_importance"></a>}}
\if{latex}{\out{\hypertarget{method-get_importance}{}}}
\subsection{Method \code{get_importance()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFTrainer$get_importance()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Returns feature importance from the model
}

\subsection{Returns}{
a data frame containing feature predictions
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data("iris")
bst <- RFTrainer$new(n_estimators=50,
                     max_depth=4,
                     classification=1,
                     seed=42,
                     verbose=TRUE)
bst$fit(iris, 'Species')
predictions <- bst$predict(iris)
bst$get_importance()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFTrainer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
