% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.fit}
\alias{.fit}
\title{Optimise a function using either numerical optimisation or grid search}
\usage{
.fit(func, fit_method = c("optim", "grid"), ...)
}
\arguments{
\item{func}{A \code{function}.}

\item{fit_method}{A \code{character} string, either \code{"optim"} or \code{"grid"}.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Named elements to replace
default optimisation settings for either \code{\link[=optim]{optim()}} or grid search. See
details.}
}
\value{
A single \code{numeric}.
}
\description{
Optimise a function using either numerical optimisation or grid search
}
\details{
Arguments passed through \link{dots} depend on whether \code{fit_method} is set to
\code{"optim"} or \code{"grid"}. For \code{"optim"}, arguments are passed to \code{\link[=optim]{optim()}},
for \code{"grid"}, the variable arguments are \code{lower}, \code{upper} (lower and
upper bounds on the grid search for the parameter being optimised, defaults
are \code{lower = 0.001} and \code{upper = 0.999}), and \code{"res"} (the resolution of
grid, default is \code{res = 0.001}).
}
\keyword{internal}
