% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offspring_distributions.R
\name{ppoislnorm}
\alias{ppoislnorm}
\title{Cumulative distribution function of the poisson-lognormal compound
distribution}
\usage{
ppoislnorm(q, meanlog, sdlog)
}
\arguments{
\item{q}{A \code{number} for the quantile of the distribution.}

\item{meanlog}{A \code{number} for the mean of the distribution on the log scale.}

\item{sdlog}{A \code{number} for the standard deviation of the distribution on
the log scale.}
}
\value{
A \code{numeric} vector of the distribution function.
}
\description{
Cumulative distribution function of the poisson-lognormal compound
distribution
}
\details{
The function is vectorised so a vector of quantiles can be input
and the output will have an equal length.
}
\examples{
ppoislnorm(q = 10, meanlog = 1, sdlog = 2)
ppoislnorm(q = 1:10, meanlog = 1, sdlog = 2)
}
