% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordination.R
\name{ordination}
\alias{ordination}
\title{Create an Ordination with Ellipses for Groups}
\usage{
ordination(mod = NULL, grps = NULL, ...)
}
\arguments{
\item{mod}{(pcoa | monoMDS/metaMDS) object returned by \code{ape::pcoa} or \code{vegan::metaMDS}}

\item{grps}{(vector) vector of categorical groups for data. Must be same length as number of rows in original data object}

\item{...}{additional arguments passed to \code{graphics::plot}, \code{graphics::points}, \code{scales::alpha}, \code{vegan::ordiellipse}, or \code{graphics::legend}. Open a GitHub Issue if function must support additional arguments}
}
\value{
(plot) base R ordination with an ellipse for each group
}
\description{
Produces a Nonmetric Multidimensional Scaling (NMS) or Principal Coordinate Analysis (PCoA) for up to 10 groups. Draws an ellipse around the standard deviation of the points in each group. By default, assigns a unique color (colorblind-safe) and point shape for each group. If the user supplies colors/shapes then the function can support more than 10 groups. For NMS ordinations, includes the stress as the legend title (see \code{?vegan::metaMDS} for explanation of "stress"). For PCoA ordinations includes the percent variation explained parenthetically in the axis labels.
}
\examples{
\donttest{
# Use data from the vegan package
utils::data("varespec", package = 'vegan')

# Make some columns of known number of groups
treatment <- c(rep.int("Trt1", (nrow(varespec)/4)),
               rep.int("Trt2", (nrow(varespec)/4)),
               rep.int("Trt3", (nrow(varespec)/4)),
               rep.int("Trt4", (nrow(varespec)/4)))

# And combine them into a single data object
data <- cbind(treatment, varespec)

# Get a distance matrix from the data
dist <- vegan::vegdist(varespec, method = 'kulczynski')

# Perform PCoA / NMS
pcoa_mod <- ape::pcoa(dist)
nms_mod <- vegan::metaMDS(data[-1], autotransform = FALSE, expand = FALSE, k = 2, try = 50)

# Create PCoA ordination (with optional agruments)
supportR::ordination(mod = pcoa_mod, grps = data$treatment, 
                     bg = c("red", "blue", "purple", "orange"),
                     lty = 2, col = "black")

# Create NMS ordination
supportR::ordination(mod = nms_mod, grps = data$treatment, alpha = 0.3, 
                     x = "topright", legend = LETTERS[1:4])
}

}
