% Generated by roxygen2 (4.0.1): do not edit by hand
\name{autoplotTen}
\alias{autoplot}
\alias{autoplot.stratTen}
\alias{autoplot.survfit}
\alias{autoplot.ten}
\alias{autoplotTen}
\title{Generate a \code{ggplot} for a \code{survfit} or \code{ten} object}
\usage{
autoplot(object, ...)

\method{autoplot}{ten}(object, ..., title = "Marks show times with censoring",
  type = c("single", "CI", "fill"), alpha = 0.05, ciLine = 10,
  censShape = 3, palette = c("Dark2", "Set2", "Accent", "Paired", "Pastel1",
  "Pastel2", "Set1", "Set3"), jitter = c("none", "noEvents", "all"),
  tabTitle = "Number at risk by time", xLab = "Time",
  timeTicks = c("major", "minor", "days", "months", "custom"), times = NULL,
  yLab = "Survival", yScale = c("perc", "frac"), legend = TRUE,
  legTitle = "Group", legLabs = NULL, legOrd = NULL, titleSize = 15,
  axisTitleSize = 15, axisLabSize = 10, survLineSize = 0.5,
  censSize = 5, legTitleSize = 10, legLabSize = 10, fillLineSize = 0.05,
  tabTitleSize = 15, tabLabSize = 5, nRiskSize = 5)

\method{autoplot}{stratTen}(object, ..., title = NULL, type = c("single",
  "CI", "fill"), alpha = 0.05, ciLine = 10, censShape = 3,
  palette = c("Dark2", "Set2", "Accent", "Paired", "Pastel1", "Pastel2",
  "Set1", "Set3"), jitter = c("none", "noEvents", "all"),
  tabTitle = "Number at risk by time", xLab = "Time",
  timeTicks = c("major", "minor", "days", "months", "custom"), times = NULL,
  yLab = "Survival", yScale = c("perc", "frac"), legend = TRUE,
  legTitle = "Group", legLabs = NULL, legOrd = NULL, titleSize = 15,
  axisTitleSize = 15, axisLabSize = 10, survLineSize = 0.5,
  censSize = 5, legTitleSize = 10, legLabSize = 10, fillLineSize = 0.05,
  tabTitleSize = 15, tabLabSize = 5, nRiskSize = 5)

\method{autoplot}{survfit}(object, ...,
  title = "Marks show times with censoring", type = c("single", "CI",
  "fill"), alpha = 0.05, ciLine = 10, censShape = 3,
  palette = c("Dark2", "Set2", "Accent", "Paired", "Pastel1", "Pastel2",
  "Set1", "Set3"), jitter = c("none", "noEvents", "all"),
  tabTitle = "Number at risk by time", xLab = "Time",
  timeTicks = c("major", "minor", "weeks", "months", "custom"),
  times = NULL, yLab = "Survival", yScale = c("perc", "frac"),
  legend = TRUE, legLabs = NULL, legOrd = NULL, legTitle = "Group",
  titleSize = 15, axisTitleSize = 15, axisLabSize = 10,
  survLineSize = 0.5, censSize = 5, legTitleSize = 10, legLabSize = 10,
  fillLineSize = 0.05, tabTitleSize = 15, tabLabSize = 5, nRiskSize = 5,
  pVal = FALSE, sigP = 1, pX = 0.1, pY = 0.1)
}
\arguments{
\item{object}{An object of class \code{survfit}, \code{ten} or \code{stratTen}.}

\item{...}{Additional arguments (not implemented).}

\item{title}{Title for survival plot.}

\item{type}{\code{type="single"} (the default) plots single lines.
 \describe{
 \item{\code{type="CI"}}{Adds lines indicating
       confidence intervals (taken from \code{upper} and \code{lower}
       values of \code{survfit} object).
       \cr
       Higher values of \code{alpha} (opacity) are recommended for this,
       e.g. \code{alpha=0.8}.}
 \item{\code{type="fill"}}{Adds filled rectangles from the survival lines to
       the confidence intervals above.}
}}

\item{alpha}{Opacity of lines indicating confidence intervals
or filled rectangles. Should be in range \eqn{0-1}. Lower = more transparent.
 \cr
Larger values e.g. \code{alpha=0.7} are recommended for confidence
intervals.}

\item{ciLine}{Confidence interval line type. See 'line type specification' in
 \cr
?graphics::par}

\item{censShape}{Shape of marks to indicate censored onservations.
 \cr
Default is \code{3} which gives vertical ticks.
 \cr
Use \code{censShape=10} for circular marks. See
 \cr
?graphics::points}

\item{palette}{Options are taken from
\href{http://colorbrewer2.org/}{color_brewer}.
  \itemize{
    \item \code{palette="Dark2"} (the default) is recommended for
          \code{single} or \code{CI} plots.
    \item \code{palette="Set2"} is recommended for \code{type="fill"} plots.
}}

\item{jitter}{By default, \code{jitter="none"}.
\itemize{
 \item If \code{jitter="noEvents"}, adds some random, positive noise
  to survival lines with no events (i.e. all observations censored).
  This will bring them just above 1 on the y-axis, making them easier to see separately.
 \item If \code{jitter="all"} add some vertical
  and horizontal noise to all survival lines. This can prevent overlapping
  of lines for censoring.
}}

\item{tabTitle}{Table title.
 \cr \cr
\bold{--Axis arguments:}}

\item{xLab}{Label for \eqn{x} axis on survival plot.}

\item{timeTicks}{Numbers to mark on the \eqn{x} axis of
the survival plot and the table.
\describe{
 \item{\code{"major"}}{
  (the default) only the major \eqn{x}-axis (time) marks from the
  survival plot are are labelled on the plot and table.}
 \item{\code{"minor"}}{minor axis marks are labelled instead.}
 \item{\code{"days"}}{scale is \eqn{0, 7, 14, ..., t_{max}}}
 \item{\code{"months"}}{scale is \eqn{0, 12,, 24, ..., t_{max}}}
 \item{\code{"custom"}}{scale is given by \code{times} below}
}}

\item{times}{Vector of custom times to use for \eqn{x} axis.}

\item{yLab}{Label for \eqn{y} axis on survival plot.}

\item{yScale}{Display for point on \eqn{y} axis:
\describe{
 \item{\code{"perc"}}{Displays as percentages.}
 \item{\code{"frac"}}{Displays as fractions e.g. \eqn{0, 0.1, 0.2, ..., 1.0.}}
}
\bold{--Legend arguments:}
 \cr}

\item{legend}{If \code{legend=FALSE}, no legends will be produced
for the plot or table.}

\item{legTitle}{Legend title.}

\item{legLabs}{Legend labels. These can be used to replace the names
of the covariate groups ('strata' in the case of a \code{survfit} object).
 \cr
Should be given in the same order as those strata.}

\item{legOrd}{Legend order.
 \cr \cr
\bold{--Size arguments:}
 \cr
 Size arguments are passed to \code{ggplot2::element_text(size=)}.}

\item{titleSize}{Title size for survival plot.}

\item{axisTitleSize}{Title size for axes.}

\item{axisLabSize}{Title size for labels on axes.}

\item{survLineSize}{Survival line size.}

\item{legTitleSize}{Title size for legend.}

\item{legLabSize}{Legend labels width and height.}

\item{censSize}{Size of marks to indicate censored onservations.}

\item{fillLineSize}{Line size surrouding filled boxes.}

\item{tabTitleSize}{Table title text size.}

\item{tabLabSize}{Table legend text size.}

\item{nRiskSize}{Number at risk - text size.
 \cr \cr
\bold{--Arguments for autoplot.survfit only:}
 \cr}

\item{pVal}{If \code{pVal=TRUE}, adds \eqn{p} value from
log-rank test to plot}

\item{sigP}{No. of significant digits to display in \eqn{p} value.
Typically \eqn{1} to \eqn{3}.}

\item{pX}{Location of \eqn{p} value on \eqn{x} axis.
 \cr
Should be in the range of \eqn{0 - 1},
where value is to be placed relative to the maximum observed
time.
 \cr
E.g. \code{pX = 0.5} will place it half-way along \eqn{x}-axis}

\item{pY}{Location of \eqn{p} value on \eqn{y} axis.
 \cr
Should be in the range of \eqn{0 - 1}, as above.}
}
\description{
Generate a \code{ggplot} for a \code{survfit} or \code{ten} object






}
\note{
\code{autoplot.survfit} may be deprecated after packageVersion 0.6.
Please try to use \code{autoplot.ten} instead.
}
\examples{
## examples are slow to run; see vignette for output from these
\dontrun{
### autoplot.ten
data("kidney", package="KMsurv")
t1 <- ten(survfit(Surv(time, delta) ~ type, data=kidney))
autoplot(t1)
autoplot(t1, type="fill", survLineSize=2, jitter="all")
autoplot(t1, timeTicks="months",
 type="CI", jitter="all",
 legLabs=c("surgical", "percutaneous"),
 title="Time to infection following catheter placement \\n
   by type of catheter, for dialysis patients",
 titleSize=10, censSize=2)$plot
t2 <- ten(survfit(Surv(time=time, event=delta) ~ 1, data=kidney))
autoplot(t2, legLabs="")$plot
autoplot(t2, legend=FALSE)
data("rectum.dat", package="km.ci")
t3 <- ten(survfit(Surv(time, status) ~ 1, data=rectum.dat))
## change confidence intervals to log Equal-Precision confidence bands
ci(t3, how="nair", tL=1, tU=40)
autoplot(t3, type="fill", legend=FALSE)$plot
## manually changing the output
t4 <- ten(survfit(Surv(time, delta) ~ type, data=kidney))
(a4 <- autoplot(t4, type="CI", alpha=0.8, survLineSize=2)$plot)
## change default colors
a4 + list(ggplot2::scale_color_manual(values=c("red", "blue")),
          ggplot2::scale_fill_manual(values=c("red", "blue")))
## change limits of y-axis
suppressMessages(a4 + ggplot2::scale_y_continuous(limits=c(0, 1)))
}
\dontrun{
data("pbc", package="survival")
t1 <- ten(Surv(time, status==2) ~ trt + strata(edema), data=pbc, abbNames=FALSE)
autoplot(t1)
}
### autoplot.survfit
\dontrun{
data(kidney, package="KMsurv")
s1 <- survfit(Surv(time, delta) ~ type, data=kidney)
autoplot(s1, type="fill", survLineSize=2)
autoplot(s1, type="CI", pVal=TRUE, pX=0.3,
 legLabs=c("surgical", "percutaneous"),
 title="Time to infection following catheter placement \\n
   by type of catheter, for dialysis patients")$plot
s1 <- survfit(Surv(time=time, event=delta) ~ 1, data=kidney)
autoplot(s1, legLabs="")$plot
autoplot(s1, legend=FALSE)$plot
data(rectum.dat, package="km.ci")
s1 <- survfit(Surv(time, status) ~ 1, data=rectum.dat)
## change confidence intervals to log Equal-Precision confidence bands
if (require("km.ci")) {
 km.ci::km.ci(s1, method="logep")
 autoplot(s1, type="fill", legend=FALSE)$plot
}
## manually changing the output
s1 <- survfit(Surv(time, delta) ~ type, data=kidney)
g1 <- autoplot(s1, type="CI", alpha=0.8, survLineSize=2)$plot
## change default colors
g1 + ggplot2::scale_colour_manual(values=c("red", "blue")) +
    ggplot2::scale_fill_manual(values=c("red", "blue"))
## change limits of y-axis
g1 + ggplot2::scale_y_continuous(limits=c(0, 1))
}
}
\author{
Chris Dardis. \code{autoplot.survfit} based on existing work by
R. Saccilotto, Abhijit Dasgupta, Gil Tomas and Mark Cowley.
}
\seealso{
?ggplot2::ggplot_build
}
\keyword{hplot}
\keyword{survival}

