% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV2_00.r
\name{smooth.spec}
\alias{smooth.spec}
\title{Covariates specified as penalized splines}
\usage{
smooth.spec(
  ...,
  knots = NULL,
  df = NULL,
  by = NULL,
  option = NULL,
  same.rho = FALSE
)
}
\arguments{
\item{...}{Numeric vectors specified in \code{\link{smf}}, \code{\link{tensor}} or \code{\link{tint}}}

\item{knots}{List of numeric vectors that specifies the knots of the splines (including boundaries); default is NULL}

\item{df}{Degrees of freedom: numeric vector that indicates the number of knots desired for each covariate; default is NULL}

\item{by}{numeric or factor variable in order to define a varying coefficient smooth; default is NULL}

\item{option}{"smf", "tensor" or "tint". Depends on the wrapper function; default is "smf"}

\item{same.rho}{if there is a factor by variable, should the smoothing parameters be the same for all levels; default is FALSE.}
}
\value{
object of class smooth.spec
\item{term}{Vector of strings giving the names of each covariate specified in ...}
\item{dim}{Numeric value giving the number of covariates associated with this spline}
\item{knots}{list of numeric vectors that specifies the knots for each covariate}
\item{df}{Numeric vector giving the number of knots associated with each covariate}
\item{by}{numeric or factor variable in order to define a varying coefficient smooth}
\item{same.rho}{if there is a factor by variable, should the smoothing parameters be the same for all levels; default is FALSE}
\item{name}{simplified name of the call to function smooth.spec}
}
\description{
Specifies the covariates to be considered as penalized splines.
}
\examples{

library(survPen)

# standard spline of time with 10 unspecified knots
smooth.spec(time)

# tensor of time and age with 5*5 specified knots
smooth.s <- smooth.spec(time,age,knots=list(time=seq(0,5,length=5),age=seq(20,80,length=5)),
option="tensor")

}
