% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillUpDecimals.R
\name{fillUpDecimals}
\alias{fillUpDecimals}
\title{Formats decimal part of numbers.}
\usage{
fillUpDecimals(numVec, howManyToFill, fill)
}
\arguments{
\item{numVec}{A vector of numbers in a numeric or character format.}

\item{howManyToFill}{The target number of digits after the decimal point. If \code{howManyToFill} is \code{NULL} (the default), then the function uses the maximum number of digits after the decimal point among the element of \code{numVec}.}

\item{fill}{What character to insert as a filler to reach the target number of digits (characters) after the decimal point. The default is \code{'0'}.}
}
\value{
A character string with equal number of decimal places after the decimal point.
}
\description{
The function adds zeros after the decimal point of each element of a numeric vector so that all elements have the same number of digits after the decimal point.
}
\details{
The function adds zeros (or other characters) after the decimal point of each element of \code{numVec} so that all elements have the same number of decimal places after the decimal point. Lower and upper case letters are treated as digits (see the examples). \code{NA} values are returned unchanged. It is not recommended to include elements with characters other than digits and letters into \code{numVec} because the function will not work as described for these elements.
}
\examples{
fillUpDecimals(c("2", "3.4", "A", NA))
fillUpDecimals(c("2", "3.4", "A.5", NA), howManyToFill = 3)
fillUpDecimals(c("2", "3.4", "A", NA), fill = "X")
fillUpDecimals(c("2", "3.4", "A", NA), howManyToFill = -3)
fillUpDecimals(c("2", "3.4", "A.zx", NA), fill = "?")
### It is not recommended to include elements
### with characters other than digits and letters
### because the function will not work as described
### for these elements
fillUpDecimals(c("2", "3.4", "A.zx", NA, "#", "#a"), fill = "?")

}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{decimal}
\keyword{digits}
