% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_profile_survival.R
\name{plot.model_profile_survival}
\alias{plot.model_profile_survival}
\title{Plot Model Profile for Survival Models}
\usage{
\method{plot}{model_profile_survival}(
  x,
  ...,
  variables = NULL,
  variable_type = NULL,
  facet_ncol = NULL,
  numerical_plot_type = "lines",
  title = "Partial dependence survival profile",
  subtitle = "default",
  colors = NULL
)
}
\arguments{
\item{x}{an object of class \code{model_profile_survival} to be plotted}

\item{...}{additional parameters, unused, currently ignored}

\item{variables}{character, names of the variables to be plotted}

\item{variable_type}{character, either \code{"numerical"}, \code{"categorical"} or \code{NULL} (default), select only one type of variable for plotting, or leave \code{NULL} for all}

\item{facet_ncol}{number of columns for arranging subplots}

\item{numerical_plot_type}{character, either \code{"lines"}, or \code{"contours"} selects the type of numerical variable plots}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, \code{'default'} automatically generates "created for XXX, YYY models", where XXX and YYY are the explainer labels}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}
}
\value{
A grid of \code{ggplot} objects arranged with the \code{gridExtra::grid.arrange} function.
}
\description{
This function plots objects of class \code{"model_profile_survival"} created
using the \code{model_profile()} function.
}
\examples{
\donttest{
library(survival)
library(survex)

model <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
exp <- explain(model)

m_prof <- model_profile(exp, categorical_variables = "trt")

plot(m_prof)

plot(m_prof, numerical_plot_type = "contours")

plot(m_prof, variables = c("trt", "age"), facet_ncol = 1)
}

}
