% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_predict_survshap}
\alias{extract_predict_survshap}
\title{Extract Local SurvSHAP(t) from Global SurvSHAP(t)}
\usage{
extract_predict_survshap(aggregated_survshap, index)
}
\arguments{
\item{aggregated_survshap}{an object of class \code{aggregated_surv_shap} containing the computed global SHAP values}

\item{index}{a numeric value, position of an observation to be extracted in the result of global explanation}
}
\value{
An object of classes \code{c("predict_parts_survival", "surv_shap")}. It is a list with the element \code{result} containing the results of the explanation.
}
\description{
Helper function to extract local SurvSHAP(t) explanation from global one.
Can be can be useful for creating SurvSHAP(t) plots for single observations.
}
\examples{
\donttest{
veteran <- survival::veteran
rsf_ranger <- ranger::ranger(
    survival::Surv(time, status) ~ .,
    data = veteran,
    respect.unordered.factors = TRUE,
    num.trees = 100,
    mtry = 3,
    max.depth = 5
)
rsf_ranger_exp <- explain(
    rsf_ranger,
    data = veteran[, -c(3, 4)],
    y = survival::Surv(veteran$time, veteran$status),
    verbose = FALSE
)

ranger_global_survshap <- model_survshap(
    explainer = rsf_ranger_exp,
    new_observation = veteran[
        c(1:4, 17:20, 110:113, 126:129),
        !colnames(veteran) \%in\% c("time", "status")
    ]
)

local_survshap_1 <- extract_predict_survshap(ranger_global_survshap, index = 1)
plot(local_survshap_1)
}

}
