% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_profile_2d.R
\name{model_profile_2d}
\alias{model_profile_2d}
\alias{model_profile_2d.surv_explainer}
\title{Dataset Level 2-Dimensional Variable Profile for Survival Models}
\usage{
model_profile_2d(
  explainer,
  variables = NULL,
  N = 100,
  categorical_variables = NULL,
  grid_points = 25,
  center = FALSE,
  variable_splits_type = "uniform",
  type = "partial",
  output_type = "survival"
)

\method{model_profile_2d}{surv_explainer}(
  explainer,
  variables = NULL,
  N = 100,
  categorical_variables = NULL,
  grid_points = 25,
  center = FALSE,
  variable_splits_type = "uniform",
  type = "partial",
  output_type = "survival"
)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}

\item{variables}{list of character vectors of length 2, names of pairs of variables to be explained}

\item{N}{number of observations used for the calculation of aggregated profiles. By default \code{100}. If \code{NULL} all observations are used.}

\item{categorical_variables}{character, a vector of names of additional variables which should be treated as categorical (factors are automatically treated as categorical variables). If it contains variable names not present in the \code{variables} argument, they will be added at the end.}

\item{grid_points}{maximum number of points for profile calculations. Note that the final number of points may be lower than grid_points. Will be passed to internal function. By default \code{25}.}

\item{center}{logical, should profiles be centered around the average prediction}

\item{variable_splits_type}{character, decides how variable grids should be calculated. Use \code{"quantiles"} for quantiles or \code{"uniform"} (default) to get uniform grid of points. Used only if \code{type = "partial"}.}

\item{type}{the type of variable profile, \code{"partial"} for Partial Dependence or \code{"accumulated"} for Accumulated Local Effects}

\item{output_type}{either \code{"survival"}, \code{"chf"} or \code{"risk"} the type of survival model output that should be considered for explanations. If \code{"survival"} the explanations are based on the survival function. If \code{"chf"} the explanations are based on the cumulative hazard function. Otherwise the scalar risk predictions are used by the \code{DALEX::predict_profile} function.}
}
\value{
An object of class \code{model_profile_2d_survival}. It is a list with the element \code{result} containing the results of the calculation.
}
\description{
This function calculates explanations on a dataset level that help explore model response as a function of selected pairs of variables.
The explanations are calculated as an extension of Partial Dependence Profiles or Accumulated Local Effects with the inclusion of the time dimension.
}
\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
cph_exp <- explain(cph)

cph_model_profile_2d <- model_profile_2d(cph_exp,
    variables = list(c("age", "celltype"))
)
head(cph_model_profile_2d$result)
plot(cph_model_profile_2d)

cph_model_profile_2d_ale <- model_profile_2d(cph_exp,
    variables = list(c("age", "karno")),
    type = "accumulated"
)
head(cph_model_profile_2d_ale$result)
plot(cph_model_profile_2d_ale)
}

}
