% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{risk_from_chf}
\alias{risk_from_chf}
\title{Generate Risk Prediction based on the Survival Function}
\usage{
risk_from_chf(predict_cumulative_hazard_function, times)
}
\arguments{
\item{predict_cumulative_hazard_function}{a function of three arguments (\code{model}, \code{newdata}, \code{times}) that allows for making cumulative hazard predictions.}

\item{times}{a numeric vector of times at which the function should be evaluated.}
}
\value{
A function of two arguments (\code{model}, \code{newdata}) returning a vector of risks.
}
\description{
Some models do not come with a ready to use risk prediction. This function allows for its generation based on the cumulative hazard function.
}
\examples{
\donttest{
library(survex)
library(survival)

rsf_src <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)

chf_function <- transform_to_stepfunction(predict,
    type = "chf",
    prediction_element = "chf",
    times_element = "time.interest"
)
risk_function <- risk_from_chf(chf_function, unique(veteran$time))

explainer <- explain(rsf_src,
    predict_cumulative_hazard_function = chf_function,
    predict_function = risk_function
)
}
}
