% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{p_meansurv}
\alias{p_meansurv}
\title{Derive a normal prior for the log hazard scale parameter based on a guess at survival times}
\usage{
p_meansurv(median, upper, mspline = NULL)
}
\arguments{
\item{median}{Best guess (prior median) for a typical survival time}

\item{upper}{Upper limit of 95\% credible interval for a survival time}

\item{mspline}{A list with components \code{knots} (vector of knots),
\code{degree} (polynomial degree) and \code{bsmooth} (logical for smoothness
constraint at boundary), defining an M-spline configuration.}
}
\value{
A normal prior in the format returned by \code{\link{p_normal}}, which can
be passed directly to the \code{prior_hscale} argument in \code{\link{survextrap}}.
}
\description{
Derive a normal prior for the log hazard scale parameter based on a
guess at survival times.  The scale parameter is hard to interpret,
and depends on the spline knots.  However for any scale parameter,
we can determine the spline coefficients that give a constant
hazard (\code{\link{mspline_constant_coefs}}).  Therefore if we can
guess a typical survival time, we can guess a typical hazard (as 1
divided by the survival time) and deduce the scale parameter.  The
prior is then constructed by assuming normality on the log scale,
and assuming the log upper credible limit is two SDs away from the
log median.
}
\seealso{
\code{\link{prior_haz_const}}, \code{\link{mspline_constant_coefs}}
}
