% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questions.R
\name{question_text_common}
\alias{question_text_common}
\title{Returns common element of question text.}
\usage{
question_text_common(x, Q)
}
\arguments{
\item{x}{A surveydata object}

\item{Q}{The question id, e.g. "Q4". If not supplied, returns the text for all questions.}
}
\value{
character vector
}
\description{
Given a question id, e.g. "Q4", finds all sub-questions, e.g. "Q4_1", "Q4_2", etc,
and returns the question text that is common to each.
}
\examples{
# Basic operations on a surveydata object, illustrated with the example dataset membersurvey

class(membersurvey)

questions(membersurvey)

which.q(membersurvey, "Q1")
which.q(membersurvey, "Q3")
which.q(membersurvey, c("Q1", "Q3"))

question_text(membersurvey, "Q3")
question_text_unique(membersurvey, "Q3")
question_text_common(membersurvey, "Q3")

# Extracting columns from a surveydata object

head(membersurvey[, "Q1"])
head(membersurvey["Q1"])
head(membersurvey[, "Q3"])
head(membersurvey[, c("Q1", "Q3")])

# Note that the result is always a surveydata object, even if only one column is extracted

head(membersurvey[, "id"])
str(membersurvey[, "id"])

}
\seealso{
Other Question functions: 
\code{\link{question_text_unique}()},
\code{\link{question_text}()},
\code{\link{questions}()},
\code{\link{split_common_unique}()},
\code{\link{which.q}()}
}
\concept{Question functions}
\keyword{Questions}
