% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplechoice.R
\name{multi_table}
\alias{multi_table}
\title{Create a table of frequencies and counts for multiple-choice questions}
\usage{
multi_table(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The columns that contain each of the response options for a
question, can be selected by using \strong{tidyselect} semanatics or providing a
vector of column names or numbers}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A gt table displaying frequencies and counts for the specified multiple-choice question.
If a grouping variable is provided, the table includes subgroups for a comprehensive analysis.
If survey weights are specified, the table notes that frequencies and counts are weighted.
}
\description{
Generates a table presenting the distribution of responses for a specified
multiple-choice question. If a grouping variable, \code{group_by}, is provided,
the table extends to include row and column totals, along with additional count and
frequency columns for each level of \code{group_by} (excluding specified subgroups, if any).
When survey weights are specified with \code{weights}, the counts reflect the weighted values,
and a note is appended at the bottom of the table.
}
\examples{
#Basic Table
 multi_table(berlinbears, question = dplyr::starts_with('will_eat'))

#Use `group_by` to partition the question into several groups
 multi_table(berlinbears, question = dplyr::starts_with('will_eat'), group_by
 = gender)

#to ignore a subgroup, use `subgroups_to_exclude`
multi_table(berlinbears, question = dplyr::starts_with('will_eat'), group_by
= gender, subgroups_to_exclude = NA)

#Specifiy survey weights with `weights`
 multi_table(berlinbears, question = dplyr::starts_with('will_eat'), group_by
 = gender, weights = weights)


}
\seealso{
Other multiple-choice questions: 
\code{\link{multi_freq}()},
\code{\link{multi_summary}()}
}
\concept{multiple-choice questions}
