% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible_survey_schemes.R
\name{feasible_survey_schemes}
\alias{feasible_survey_schemes}
\title{Find all feasible survey schemes}
\usage{
feasible_survey_schemes(
  site_data,
  cost_column,
  survey_budget,
  locked_in_column = NULL,
  locked_out_column = NULL,
  verbose = FALSE
)
}
\arguments{
\item{site_data}{\code{\link[sf:sf]{sf::sf()}} object containing the candidate survey
sites.}

\item{cost_column}{\code{character} name of the column in the argument to
the argument to \code{site_data} that contains the cost for surveying each
site. No missing (\code{NA}) values are permitted.}

\item{survey_budget}{\code{numeric} the maximum possible expenditure
permitted for conducting surveys.}

\item{locked_in_column}{\code{character} (optional) name of the column in
the argument to \code{site_data} that contains \code{logical}
(\code{TRUE}/ \code{FALSE}) values indicating if certain sites should be
locked into the survey scheme.
No missing (\code{NA}) values are permitted.
Defaults to \code{NULL} such that no sites are locked in.}

\item{locked_out_column}{\code{character} (optional) name of the column in
the argument to \code{site_data} that contains \code{logical}
(\code{TRUE}/ \code{FALSE}) values indicating if certain sites should be
locked out of the survey scheme.
No missing (\code{NA}) values are permitted.
Defaults to \code{NULL} such that no sites are locked out.}

\item{verbose}{\code{logical} indicating if information should be
printed while searching for feasible schemes. Defaults to \code{FALSE}.}
}
\value{
\code{\link[=matrix]{matrix()}} where each row corresponds to a different
survey scheme, and each column corresponds to a different planning unit.
Cell values are \code{logical} (\code{TRUE} / \code{FALSE}) indicating
if a given site is selected in a given survey scheme.
}
\description{
Generate a \code{matrix} representing all possible different
survey schemes given survey costs and a fixed budget.
}
\section{Dependencies}{

Please note that this function requires the Gurobi optimization software
(\url{https://www.gurobi.com/}) and the \pkg{gurobi} R package if different
sites have different survey costs. Installation instruction are available
online for for \href{https://www.gurobi.com/documentation/9.1/quickstart_linux/r_ins_the_r_package.html}{Linux}, \href{https://www.gurobi.com/documentation/9.1/quickstart_windows/r_ins_the_r_package.html}{Windows}, and \href{https://www.gurobi.com/documentation/9.1/quickstart_mac/r_ins_the_r_package.html}{Mac OS}.
}

\examples{
\dontrun{
# set seed for reproducibility
set.seed(123)

# simulate data
x <- sf::st_as_sf(tibble::tibble(x = rnorm(4), y = rnorm(4),
                                 cost = c(100, 200, 0.2, 1)),
                  coords = c("x", "y"))

# print data
print(x)

# plot site locations
plot(st_geometry(x), pch = 16, cex = 3)

# generate all feasible schemes given a budget of 4
s <- feasible_survey_schemes(x, "cost", survey_budget = 4)

# print schemes
print(s)

# plot first scheme
x$scheme_1 <- s[1, ]
plot(x[, "scheme_1"], pch = 16, cex = 3)
}
}
