% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WCHdf.R
\name{WCHdf}
\alias{WCHdf}
\title{Weighted cumulative hazard estimator for the bivariate distribution function}
\usage{
WCHdf(object, x, y)
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the bivariate 
distribution function.}

\item{y}{The second time for obtaining estimates for the bivariate 
distribution function.}
}
\value{
Vector with the Weighted cumulative hazard estimates for the 
bivariate distribution function.
}
\description{
Provides estimates for the bivariate distribution function based 
on Weighted cumulative hazard estimator (WCH).
}
\examples{
data("bladder3")

b3<-multidf(gap1=bladder3$t1, event1=bladder3$d1, 
            gap2=bladder3$t2-bladder3$t1,status=bladder4state$d2)  

head(b3[[1]])
WCHdf(b3,x=13,y=20)

}
\references{
Wang, M.C. and Wells, M.T. (1998). Nonparametric Estimation of 
successive duration times under dependent censoring, Biometrika 85, 561-572.
}
\seealso{
\code{\link{IPCWdf}}, \code{\link{KMWdf}}, \code{\link{LINdf}} and 
\code{\link{LDMdf}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
