% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{tribe_colours}
\alias{tribe_colours}
\title{Tribe colours}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{version}}{Country code for the version of the show}
  \item{\code{version_season}}{Version season key}
  \item{\code{season_name}}{The season name}
  \item{\code{season}}{The season number}
  \item{\code{tribe}}{Tribe name}
  \item{\code{tribe_colour}}{Colour of the tribe}
  \item{\code{tribe_status}}{Tribe status e.g. original, swapped or merged. In the instance where a tribe is formed at the swap by
  splitting 2 tribes into 3, the 3rd tribe will be labelled 'swapped'}
}
}
\source{
\url{https://survivor.fandom.com/wiki/Tribe}
}
\usage{
tribe_colours
}
\description{
A dataset containing the tribe colours for each season
}
\examples{
library(ggplot2)
library(dplyr)
library(forcats)
df <- tribe_colours \%>\%
  group_by(season_name) \%>\%
  mutate(
    xmin = 1,
    xmax = 2,
    ymin = 1:n(),
    ymax = ymin + 1
  ) \%>\%
  ungroup() \%>\%
  mutate(
    season_name = fct_reorder(season_name, season),
    font_colour = ifelse(tribe_colour == "#000000", "white", "black")
  )
ggplot() +
  geom_rect(data = df,
    mapping = aes(xmin = xmin, xmax = xmax, ymin = ymin, ymax = ymax),
    fill = df$tribe_colour) +
  geom_text(data = df,
    mapping = aes(x = xmin+0.5, y = ymin+0.5, label = tribe),
    colour = df$font_colour) +
  theme_void() +
  facet_wrap(~season_name, scales = "free_y")
}
\keyword{datasets}
