% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{confint.survstan}
\alias{confint.survstan}
\title{Confidence intervals for the regression coefficients}
\usage{
\method{confint}{survstan}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{an object of the class survstan.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
100(1-alpha) confidence intervals for the regression coefficients.
}
\description{
Confidence intervals for the regression coefficients
}
\examples{
\donttest{
library(survstan)
fit <- aftreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull", init = 0)
confint(fit)
}

}
