% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_c_stat.R
\name{get_c_stat}
\alias{get_c_stat}
\title{Calculate C-statistics}
\usage{
get_c_stat(in.df, endpoint, endpoint.code, prog.factor, tau.val)
}
\arguments{
\item{in.df}{data.frame containing all the input data.}

\item{endpoint}{Column name of endpoint.}

\item{endpoint.code}{Column name of endpoint code.}

\item{prog.factor}{Column name of the prognostic factor to test.}

\item{tau.val}{Vector of tau values to be used for C-statistics inference.}
}
\value{
data.frame containing the c-statistic, 95% CI, and standard error.
}
\description{
Wrapper around the Inf.Cval function from the survC1 R package to calculate
C-statistics.
}
\examples{
# Example taken from survC1
\dontrun{
library("survival")
in.df <- survC1::CompCase(pbc[1:200, c(2:4,10:14)])
in.df[, 2] <- as.numeric(in.df[,2]==2)
tau <- 365.25*8
prog.factor <- c("trt", "edema", "bili", "chol", "albumin", "copper")
get_c_stat(in.df, "time", "status", prog.factor, tau)
}
}
