% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_performance.R
\name{plot.surv_model_performance_explainer}
\alias{plot.surv_model_performance_explainer}
\title{Plot for surv_model_performance object}
\usage{
\method{plot}{surv_model_performance_explainer}(x, ...)
}
\arguments{
\item{x}{object of class "surv_model_performance"}

\item{...}{other arguments}
}
\description{
Function plot for surv_model_performance object.
}
\examples{
\donttest{
library(survxai)
library(rms)
data("pbcTest")
data("pbcTrain")
predict_times <- function(model, data, times){
                  prob <- rms::survest(model, data, times = times)$surv
                  return(prob)
                  }
cph_model <- cph(Surv(years, status)~., data=pbcTrain, surv=TRUE, x = TRUE, y=TRUE)
surve_cph <- explain(model = cph_model, data = pbcTest[,-c(1,5)], 
                    y = Surv(pbcTest$years, pbcTest$status), predict_function = predict_times)
mp_cph <- model_performance(surve_cph, data = pbcTest)
plot(mp_cph)
}

}
