#' Parses the content of an error generated by parse
#' 
#' Makes sense of a \code{parse} error and structure the information
#' @export
#' @param err An error as generated by \code{parse} 
#' @return A data.frame with the following columns : file, line, message and type
#' @author Romain Francois \email{francoisromain@@free.fr}
parseError <- function( err ){
  msg     <- err %/~% "\\\n"
  line.nb <- msg %~% "^\\d+"
  if( any( line.nb ) ){
  	msg     <- msg[ 1:( min( which( line.nb) ) - 1) ]
  	msg     <- paste( msg, collapse = "" )
  } else{
	msg <- ""
  }
  
  rx      <- "^.*?:\\s*(.*?):(.*?):(.*?):(.*)$"
  file    <- sub( rx, "\\1", msg, perl = TRUE )
  line    <- as.integer( sub( rx, "\\2", msg, perl = TRUE )  )
  col     <- as.integer( sub( rx, "\\3", msg, perl = TRUE )  )
  message <- sub( rx, "\\4", msg, perl = TRUE )
  
  data.frame( file = file, 
    line = line, message = message, 
    type = "error", stringsAsFactors = FALSE )
}

