#' Tries to parse a file
#' 
#' Tries to parse a file and structure the error if it cannot be
#' @param file A file to \link{parse} 
#' @param action A function to call on the structured error 
#' @return If the parsing is sucessful, the output of the standard parse function is returned
#' otherwise, the error that is generated by parse is structured by \code{\link{parseError}}
#' @author Romain Francois \email{francoisromain@@free.fr}
tryParse <- function(file, action, encoding = "unknown" ){
	
	if( is.character(file) ){
		filename <- file
		file <- file( filename, encoding = encoding )
		on.exit( close( file ) )
	} else{
		filename <- summary( file )$description
	}
	
  out <- try( parse(file, srcfile = filename) , silent = TRUE)
  if( inherits(out, "try-error") ) {
		err <- parseError( out )
		if( !missing(action) ) action( err )
		invisible( err )
	} else invisible(out)  
}

