% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/js_test.R
\name{js.test}
\alias{js.test}
\title{Chi-square test for joint hypotheses}
\usage{
js.test(x, R, r = NULL)
}
\arguments{
\item{x}{Object of class 'sboot'}

\item{R}{A J*K^2 selection matrix, where J is the number of hypotheses and K the number of time series.}

\item{r}{A J*1 vector of restrictions}
}
\value{
A list with elements
\item{test_statistic}{Test statistic}
\item{p_value}{P-value}
}
\description{
Based on an existing bootstrap object, the test statistic allows to test joint hypotheses for selected entries of the structural matrix B. The test statistic reads as
\deqn{(Rvec(\widehat{B}) - r)'R(\widehat{\mbox{Cov}}[vec(B^*)])^{-1}R'(Rvec(\widehat{b} - r)) \sim \chi^2_J,}
where \eqn{\widehat{\mbox{Cov}}[vec(B^*)]} is the estimated covariance of vectorized bootstrap estimates of structural parameters. The composite null hypothesis is \eqn{H_0: Rvec(B)= r}.
}
\examples{
\donttest{
# data contains quarterly observations from 1965Q1 to 2008Q3
# x = output gap
# pi = inflation
# i = interest rates
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.dc(v1)

# Bootstrapping of SVAR
bb <- wild.boot(x1, nboot = 1000, horizon = 30)

# Testing the hypothesis of a lower triangular matrix as
# relation between structural and reduced form errors
R <- rbind(c(0,0,0,1,0,0,0,0,0), c(0,0,0,0,0,0,1,0,0),
           c(0,0,0,0,0,0,0,1,0))
c.test <- js.test(bb, R)
summary(c.test)
}

}
\references{
Herwartz, H., 2017. Hodges Lehmann detection of structural shocks -
       An analysis of macroeconomic dynamics in the Euro Area, Oxford Bulletin of Economics and Statistics
}
