% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdvis.R
\name{svd.scatter}
\alias{svd.scatter}
\title{Visualizing Singular Vectors or Principal Components by Scatterplot Matrices}
\usage{
svd.scatter(svd.obj, r = NULL, group = NULL, weights = NULL,
  alpha = 0.7, axisLabels = "none", ...)
}
\arguments{
\item{svd.obj}{A list, resulted from applying svd to a dataset, with \code{u}, \code{d}, and \code{v} corresponding to left singular vector, singular values, and right singular vectors, respectively. Alternatively, supply singular vectors, \code{v}.}

\item{r}{A positive integer to use only the first \code{r} vectors in visualization. If not specified, all vectors available in \code{svd.obj$v} are visualized.}

\item{group}{A vector of length \code{n}, specifying groups (e.g., phenotypes or conditions for \code{n} samples).}

\item{weights}{A vector of length \code{r}. If "sv", singular values contained in \code{svd.obj$d[1:r]} are used.}

\item{alpha}{A numeric value for transparency.}

\item{axisLabels}{Set to either "none" (default), "show", or "internal".}

\item{...}{Additional arguments to pass onto \code{ggpair}.}
}
\value{
\code{svd.scatter} creates and draws a figure, which is a \code{ggpair} object.
}
\description{
Creates a set of multiple scatter plots from all pairs of selected singular vectors or principal components.
Principal components can be plotted by setting \code{weights = "sv"}.
Since it largely uses \code{ggpairs} from the \code{GGally} package, optional arguments for \code{ggpairs} can be specified.
}
\examples{
set.seed(1234)
dat = matrix(rnorm(1000), 100, 10)
svd.obj = svd(dat)
colnames(svd.obj$v) = paste0("V",1:10)
svd.scatter(svd.obj, r=3, group=c(rep("Group1",5), rep("Group2",5)))
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
\seealso{
\link{ggpairs}
}

