% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{add_web_fonts}
\alias{add_web_fonts}
\title{Add web font imports to an already created SVG file}
\usage{
add_web_fonts(filename, web_fonts)
}
\arguments{
\item{filename}{The svgfile(s) or \code{svg} object(s) (as created by
\code{\link[=svgstring]{svgstring()}}) to edit}

\item{web_fonts}{A list containing web fonts to use in the SVG. The fonts
will still need to be available locally on the computer running the code,
but viewers of the final SVG will not need the font if specified as a web
font. Web fonts can either be specified using \code{\link[=font_face]{font_face()}} or given as a
single string in which case they are taken to be URL's for an \verb{@import}
directive to e.g. Google Fonts. For the latter, you can use
\code{\link[=fonts_as_import]{fonts_as_import()}} to automatically generate the string, optionally
embedding the font data in it. If the passed in string is not in the form
of a URL or \verb{@import} statement then it is considered a font family name
and \code{\link[=fonts_as_import]{fonts_as_import()}} will be called to convert it to an import
automatically, using the default arguments.}
}
\value{
Invisibly returns \code{filename}. If any of elements of this were inline
SVGs then these have been modified to include the imports
}
\description{
This function allows you to add web fonts after creation. The result is the
same as using the \code{web_fonts} argument in \code{\link[=svglite]{svglite()}}. Only SVGs created with
svglite can get web fonts added.
}
