% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{display_svg}
\alias{display_svg}
\title{Display SVG on standard graphic display port}
\usage{
display_svg(svg, width = NULL, height = NULL)
}
\arguments{
\item{svg}{XML document with SVG content.}

\item{width}{Desired width (in px) of image (default NULL).}

\item{height}{Desired height (in px) of image (default NULL).}
}
\description{
Display SVG on standard graphic display port
}
\details{
Viewport depends on system and IDE. In RStudio the image is displayed under 'Viewer'.\cr
If neither width nor height are specified the image will have its size depending on DPI settings. If only one of these is specified, the other one is scaled accordingly.
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig1.svg", package="svgtools")
svg <- read_svg(file = fpath)

#display SVG file in standard viewport
display_svg(svg = svg, width = 500)
}
